/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import joshie.durabilitydecay.DurabilityDecay;
import joshie.durabilitydecay.config.DecayRule;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DecayConfig {
    private DecayRule defaultRule = DecayRule.defaultRule();
    private final Map<ResourceLocation, DecayRule> itemRules = new HashMap<ResourceLocation, DecayRule>();
    private final Map<ResourceLocation, DecayRule> tagRules = new HashMap<ResourceLocation, DecayRule>();
    private final Set<ResourceLocation> disabledItems = new HashSet<ResourceLocation>();

    public DecayRule getRuleForItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return this.defaultRule;
        }
        Item item = stack.getItem();
        ResourceLocation itemId = this.getItemId(item);
        if (this.disabledItems.contains(itemId)) {
            return null;
        }
        if (this.itemRules.containsKey(itemId)) {
            return this.itemRules.get(itemId);
        }
        for (TagKey tagKey : BuiltInRegistries.ITEM.getHolderOrThrow((ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)item).get()).tags().toList()) {
            ResourceLocation tagId = tagKey.location();
            if (!this.tagRules.containsKey(tagId)) continue;
            return this.tagRules.get(tagId);
        }
        return this.defaultRule;
    }

    public boolean shouldApplyDecay(ItemStack stack) {
        if (stack.isEmpty() || !stack.isDamageableItem()) {
            return false;
        }
        DecayRule rule = this.getRuleForItem(stack);
        return rule != null;
    }

    public void loadFromJson(String jsonString) {
        try {
            JsonObject root = JsonParser.parseString((String)jsonString).getAsJsonObject();
            if (root.has("default")) {
                this.defaultRule = DecayRule.fromJson(root.getAsJsonObject("default"));
            }
            if (root.has("items")) {
                JsonObject items = root.getAsJsonObject("items");
                for (Map.Entry entry : items.entrySet()) {
                    DecayRule rule;
                    String key = (String)entry.getKey();
                    if (key.startsWith("#")) {
                        ResourceLocation tagId = ResourceLocation.parse((String)key.substring(1));
                        rule = DecayRule.fromJson(((JsonElement)entry.getValue()).getAsJsonObject());
                        this.tagRules.put(tagId, rule);
                        continue;
                    }
                    if (key.equals("disabled")) {
                        for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                            this.disabledItems.add(ResourceLocation.parse((String)element.getAsString()));
                        }
                        continue;
                    }
                    ResourceLocation itemId = ResourceLocation.parse((String)key);
                    rule = DecayRule.fromJson(((JsonElement)entry.getValue()).getAsJsonObject());
                    this.itemRules.put(itemId, rule);
                }
            }
            DurabilityDecay.LOGGER.info("Loaded decay config: {} item rules, {} tag rules", (Object)this.itemRules.size(), (Object)this.tagRules.size());
        }
        catch (Exception e) {
            DurabilityDecay.LOGGER.error("Failed to parse decay config JSON", (Throwable)e);
        }
    }

    public void clear() {
        this.defaultRule = DecayRule.defaultRule();
        this.itemRules.clear();
        this.tagRules.clear();
        this.disabledItems.clear();
    }

    private ResourceLocation getItemId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public DecayRule getDefaultRule() {
        return this.defaultRule;
    }
}

