/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.config;

import com.google.gson.JsonObject;

public class DecayRule {
    public final double base;
    public final double fraction;
    public final double max;
    public final double min;
    public final boolean mendingImpactsBlock;
    public final boolean allowDecayRestoration;
    public final double restorationMinThreshold;
    public final double restorationBase;
    public final double restorationScaling;
    public final double restorationMinAmount;
    public final double restorationTierBonus;
    public final double restorationWorkPenalty;
    public final double restorationMaxCap;

    public DecayRule(double base, double fraction, double max, double min, boolean mendingImpactsBlock, boolean allowDecayRestoration, double restorationMinThreshold, double restorationBase, double restorationScaling, double restorationMinAmount, double restorationTierBonus, double restorationWorkPenalty, double restorationMaxCap) {
        this.base = Math.max(0.0, base);
        this.fraction = Math.max(0.0, Math.min(1.0, fraction));
        this.max = Math.max(0.0, max);
        this.min = Math.max(0.0, min);
        this.mendingImpactsBlock = mendingImpactsBlock;
        this.allowDecayRestoration = allowDecayRestoration;
        this.restorationMinThreshold = restorationMinThreshold;
        this.restorationBase = restorationBase;
        this.restorationScaling = restorationScaling;
        this.restorationMinAmount = restorationMinAmount;
        this.restorationTierBonus = restorationTierBonus;
        this.restorationWorkPenalty = restorationWorkPenalty;
        this.restorationMaxCap = restorationMaxCap;
    }

    public static DecayRule defaultRule() {
        return new DecayRule(0.0, 0.25, 0.5, 0.0, false, true, 0.4, 0.12, 0.5, 0.03, 0.02, 0.8, 0.95);
    }

    public static DecayRule fromJson(JsonObject json) {
        double base = json.has("base") ? json.get("base").getAsDouble() : 0.0;
        double fraction = json.has("fraction") ? json.get("fraction").getAsDouble() : 0.25;
        double max = json.has("max") ? json.get("max").getAsDouble() : 0.5;
        double min = json.has("min") ? json.get("min").getAsDouble() : 0.0;
        boolean mendingImpacts = json.has("mending_impacts_block") && json.get("mending_impacts_block").getAsBoolean();
        boolean allowRestoration = json.has("allow_decay_restoration") ? json.get("allow_decay_restoration").getAsBoolean() : true;
        double restorationMinThreshold = json.has("restoration_min_threshold") ? json.get("restoration_min_threshold").getAsDouble() : 0.4;
        double restorationBase = json.has("restoration_base") ? json.get("restoration_base").getAsDouble() : 0.12;
        double restorationScaling = json.has("restoration_scaling") ? json.get("restoration_scaling").getAsDouble() : 0.5;
        double restorationMinAmount = json.has("restoration_min_amount") ? json.get("restoration_min_amount").getAsDouble() : 0.03;
        double restorationTierBonus = json.has("restoration_tier_bonus") ? json.get("restoration_tier_bonus").getAsDouble() : 0.02;
        double restorationWorkPenalty = json.has("restoration_work_penalty") ? json.get("restoration_work_penalty").getAsDouble() : 0.8;
        double restorationMaxCap = json.has("restoration_max_cap") ? json.get("restoration_max_cap").getAsDouble() : 0.95;
        return new DecayRule(base, fraction, max, min, mendingImpacts, allowRestoration, restorationMinThreshold, restorationBase, restorationScaling, restorationMinAmount, restorationTierBonus, restorationWorkPenalty, restorationMaxCap);
    }

    public static int toAbsolute(double value, int maxDurability) {
        if (value <= 1.0) {
            return (int)Math.ceil(value * (double)maxDurability);
        }
        return (int)Math.ceil(value);
    }

    public int calculateDecay(int repairedAmount, int maxDurability, int currentDecay) {
        if (maxDurability <= 0 || repairedAmount <= 0) {
            return 0;
        }
        int baseDecay = DecayRule.toAbsolute(this.base, maxDurability);
        int fractionalDecay = (int)Math.ceil((double)repairedAmount * this.fraction);
        int totalDecay = baseDecay + fractionalDecay;
        int minDecayPerOp = DecayRule.toAbsolute(this.min, maxDurability);
        int maxDecayPerOp = DecayRule.toAbsolute(this.max, maxDurability);
        totalDecay = Math.max(totalDecay, minDecayPerOp);
        totalDecay = Math.min(totalDecay, maxDecayPerOp);
        return totalDecay;
    }

    public double calculateDecayRestoration(double cap1, double cap2, int priorWork, boolean isSameTier) {
        if (!this.allowDecayRestoration) {
            return Math.max(cap1, cap2);
        }
        double cMin = Math.min(cap1, cap2);
        double cMax = Math.max(cap1, cap2);
        if (cMin < this.restorationMinThreshold) {
            return cMin;
        }
        double r = Math.min(this.restorationBase, this.restorationScaling * (cMax - cMin));
        if (r < this.restorationMinAmount) {
            r = this.restorationMinAmount;
        }
        double cNew = Math.min(this.restorationMaxCap, cMin + (r *= Math.pow(this.restorationWorkPenalty, priorWork)));
        return cNew;
    }

    public String toString() {
        return String.format("DecayRule{base=%.2f, fraction=%.2f, max=%.2f, min=%.2f, mending=%s, restoration=%s}", this.base, this.fraction, this.max, this.min, this.mendingImpactsBlock, this.allowDecayRestoration);
    }
}

