/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.mixin;

import joshie.durabilitydecay.mixin.ItemCombinerMenuAccess;
import joshie.durabilitydecay.util.DecayCalculator;
import joshie.durabilitydecay.util.DecayData;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin {
    @Inject(method={"createResult()V"}, at={@At(value="RETURN")})
    private void onAnvilRepair(CallbackInfo ci) {
        int damageAfter;
        ItemStack leftItem = ((ItemCombinerMenuAccess)((Object)this)).getInputSlots().getItem(0);
        ItemStack rightItem = ((ItemCombinerMenuAccess)((Object)this)).getInputSlots().getItem(1);
        ItemStack result = ((ItemCombinerMenuAccess)((Object)this)).getResultSlots().getItem(0);
        if (result.isEmpty() || leftItem.isEmpty()) {
            return;
        }
        if (!leftItem.isDamageableItem() || !DecayCalculator.shouldApplyDecay(leftItem)) {
            return;
        }
        int damageBefore = leftItem.getDamageValue();
        int repairedAmount = DecayCalculator.calculateRepairedAmount(damageBefore, damageAfter = result.getDamageValue());
        if (repairedAmount > 0) {
            int existingDecay = DecayData.getDecay(leftItem);
            DecayData.setDecay(result, existingDecay);
            DecayCalculator.applyDecay(result, repairedAmount, false);
            int newDecay = DecayData.getDecay(result);
            int maxDamage = result.getMaxDamage();
            int effectiveMaxDamage = maxDamage - newDecay;
            int currentDamage = result.getDamageValue();
            int minAllowedDamage = maxDamage - effectiveMaxDamage;
            if (currentDamage < minAllowedDamage) {
                result.setDamageValue(minAllowedDamage);
            }
        }
    }
}

