/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.mixin;

import joshie.durabilitydecay.mixin.ItemCombinerMenuAccess;
import joshie.durabilitydecay.util.DecayData;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuRepairMixin {
    @Inject(method={"createResult()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventMaxDecayRepair(CallbackInfo ci) {
        int minAllowedDamage;
        ItemStack leftItem = ((ItemCombinerMenuAccess)((Object)this)).getInputSlots().getItem(0);
        ItemStack rightItem = ((ItemCombinerMenuAccess)((Object)this)).getInputSlots().getItem(1);
        if (leftItem.isEmpty() || !leftItem.isDamageableItem()) {
            return;
        }
        int decay = DecayData.getDecay(leftItem);
        if (decay <= 0) {
            return;
        }
        int maxDamage = leftItem.getMaxDamage();
        int effectiveMaxDamage = maxDamage - decay;
        if (effectiveMaxDamage <= 1) {
            ((ItemCombinerMenuAccess)((Object)this)).getResultSlots().setItem(0, ItemStack.EMPTY);
            ci.cancel();
            return;
        }
        int currentDamage = leftItem.getDamageValue();
        if (currentDamage <= (minAllowedDamage = maxDamage - effectiveMaxDamage) && !rightItem.isEmpty()) {
            if (rightItem.isDamageableItem() || rightItem.isEnchanted()) {
                return;
            }
            if (leftItem.getItem().isValidRepairItem(leftItem, rightItem)) {
                ((ItemCombinerMenuAccess)((Object)this)).getResultSlots().setItem(0, ItemStack.EMPTY);
                ci.cancel();
            }
        }
    }
}

