/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.mixin;

import joshie.durabilitydecay.util.DecayCalculator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ExperienceOrb.class})
public abstract class ExperienceOrbMixin {
    @Shadow
    private int value;
    @Unique
    private ItemStack durability_decay$lastRepairedItem = ItemStack.EMPTY;
    @Unique
    private int durability_decay$lastDamageValue = 0;

    @Inject(method={"repairPlayerItems(Lnet/minecraft/server/level/ServerPlayer;I)I"}, at={@At(value="HEAD")})
    private void captureBeforeRepair(ServerPlayer player, int value, CallbackInfoReturnable<Integer> cir) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = player.getItemBySlot(slot);
            if (!stack.isDamaged() || !stack.isDamageableItem()) continue;
            this.durability_decay$lastRepairedItem = stack;
            this.durability_decay$lastDamageValue = stack.getDamageValue();
            break;
        }
    }

    @Inject(method={"repairPlayerItems(Lnet/minecraft/server/level/ServerPlayer;I)I"}, at={@At(value="RETURN")})
    private void applyDecayAfterRepair(ServerPlayer player, int value, CallbackInfoReturnable<Integer> cir) {
        if (!this.durability_decay$lastRepairedItem.isEmpty()) {
            int damageAfter = this.durability_decay$lastRepairedItem.getDamageValue();
            int repairedAmount = DecayCalculator.calculateRepairedAmount(this.durability_decay$lastDamageValue, damageAfter);
            if (repairedAmount > 0) {
                DecayCalculator.applyDecay(this.durability_decay$lastRepairedItem, repairedAmount, true);
            }
            this.durability_decay$lastRepairedItem = ItemStack.EMPTY;
            this.durability_decay$lastDamageValue = 0;
        }
    }
}

