/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.mixin;

import joshie.durabilitydecay.config.ConfigManager;
import joshie.durabilitydecay.config.DecayRule;
import joshie.durabilitydecay.util.DecayCalculator;
import joshie.durabilitydecay.util.DecayData;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GrindstoneMenu.class})
public abstract class GrindstoneMenuMixin {
    @Shadow
    Container repairSlots;
    @Shadow
    private Container resultSlots;

    @Inject(method={"createResult()V"}, at={@At(value="RETURN")})
    private void onGrindstoneRepair(CallbackInfo ci) {
        ItemStack topItem = this.repairSlots.getItem(0);
        ItemStack bottomItem = this.repairSlots.getItem(1);
        ItemStack result = this.resultSlots.getItem(0);
        if (result.isEmpty()) {
            return;
        }
        if (topItem.isEmpty() || bottomItem.isEmpty()) {
            return;
        }
        if (!topItem.isDamageableItem() || !DecayCalculator.shouldApplyDecay(topItem)) {
            return;
        }
        int topDecay = DecayData.getDecay(topItem);
        int bottomDecay = DecayData.getDecay(bottomItem);
        int maxDamage = result.getMaxDamage();
        double cap1 = (double)topDecay / (double)maxDamage;
        double cap2 = (double)bottomDecay / (double)maxDamage;
        int priorWork = 0;
        priorWork = (Integer)topItem.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
        boolean isSameTier = topItem.getItem() == bottomItem.getItem();
        DecayRule rule = ConfigManager.getInstance().getConfig().getRuleForItem(topItem);
        double newCap = rule != null ? rule.calculateDecayRestoration(cap1, cap2, priorWork, isSameTier) : Math.max(cap1, cap2);
        int newDecay = (int)Math.ceil(newCap * (double)maxDamage);
        DecayData.setDecay(result, newDecay);
        int topDamage = topItem.getDamageValue();
        int bottomDamage = bottomItem.getDamageValue();
        int resultDamage = result.getDamageValue();
        int worseDamage = Math.max(topDamage, bottomDamage);
        int repairedAmount = DecayCalculator.calculateRepairedAmount(worseDamage, resultDamage);
        if (repairedAmount > 0) {
            DecayCalculator.applyDecay(result, repairedAmount, false);
            int newDecay1 = DecayData.getDecay(result);
            int maxDamage1 = result.getMaxDamage();
            int effectiveMaxDamage = maxDamage - newDecay1;
            int currentDamage = result.getDamageValue();
            int minAllowedDamage = maxDamage1 - effectiveMaxDamage;
            if (currentDamage < minAllowedDamage) {
                result.setDamageValue(minAllowedDamage);
            }
        }
    }

    private boolean isItemDiamondTierOrHigher(ItemStack stack) {
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        return itemId.contains("diamond") || itemId.contains("netherite");
    }
}

