/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.mixin;

import joshie.durabilitydecay.util.DecayData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"getBarWidth(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void adjustBarForDecay(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (stack.isEmpty() || !stack.isDamageableItem()) {
            return;
        }
        int decay = DecayData.getDecay(stack);
        if (decay <= 0) {
            return;
        }
        int maxDamage = stack.getMaxDamage();
        int effectiveMaxDamage = maxDamage - decay;
        int currentDamage = stack.getDamageValue();
        int effectiveDamage = Math.max(0, currentDamage - (maxDamage - effectiveMaxDamage));
        int barWidth = Math.round(13.0f - (float)effectiveDamage * 13.0f / (float)effectiveMaxDamage);
        cir.setReturnValue((Object)barWidth);
    }
}

