/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.mixin;

import joshie.durabilitydecay.util.DecayData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public class ItemRendererMixin {
    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="TAIL")})
    private void renderDecayBar(Font font, ItemStack stack, int x, int y, String text, CallbackInfo ci) {
        GuiGraphics graphics = (GuiGraphics)this;
        if (stack.isEmpty() || !stack.isDamageableItem()) {
            return;
        }
        int decay = DecayData.getDecay(stack);
        if (decay <= 0) {
            return;
        }
        int maxDamage = stack.getMaxDamage();
        if (maxDamage <= 0) {
            return;
        }
        int barWidth = 13;
        float decayFraction = (float)decay / (float)maxDamage;
        int decayWidth = Math.round((float)barWidth * decayFraction);
        if (decayWidth <= 0) {
            return;
        }
        int barX = x + 2;
        int barY = y + 13;
        int decayStartX = barX + barWidth - decayWidth;
        graphics.fill(decayStartX, barY, decayStartX + decayWidth, barY + 2, -10092544);
        graphics.fill(decayStartX, barY, decayStartX + decayWidth, barY + 1, -38002);
    }
}

