/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.mixin;

import java.util.List;
import joshie.durabilitydecay.util.DecayData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"getTooltipLines(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, at={@At(value="RETURN")})
    private void modifyDurabilityTooltip(Item.TooltipContext context, Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir) {
        ItemStack stack = (ItemStack)this;
        if (stack.isEmpty() || !stack.isDamageableItem()) {
            return;
        }
        int decay = DecayData.getDecay(stack);
        if (decay <= 0) {
            return;
        }
        if (!flag.isAdvanced()) {
            return;
        }
        List tooltip = (List)cir.getReturnValue();
        int maxDamage = stack.getMaxDamage();
        int currentDamage = stack.getDamageValue();
        int effectiveMaxDamage = maxDamage - decay;
        int currentDurability = maxDamage - currentDamage;
        for (int i = 0; i < tooltip.size(); ++i) {
            String text = ((Component)tooltip.get(i)).getString();
            if (!text.contains("Durability:")) continue;
            MutableComponent newLine = Component.literal((String)"Durability: ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(currentDurability + " / " + effectiveMaxDamage)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" (-" + decay + ")")).withStyle(ChatFormatting.RED));
            tooltip.set(i, newLine);
            break;
        }
    }
}

