/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.mixin;

import joshie.durabilitydecay.util.DecayData;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public class ItemStackRepairMixin {
    @Inject(method={"setDamageValue(I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void enforceDecayLimit(int damage, CallbackInfo ci) {
        int effectiveMaxDamage;
        ItemStack stack = (ItemStack)this;
        if (stack.isEmpty() || !stack.isDamageableItem()) {
            return;
        }
        int decay = DecayData.getDecay(stack);
        if (decay <= 0) {
            return;
        }
        int maxDamage = stack.getMaxDamage();
        if (damage < maxDamage - (effectiveMaxDamage = maxDamage - decay)) {
            ci.cancel();
            stack.set(DataComponents.DAMAGE, (Object)(maxDamage - effectiveMaxDamage));
        }
    }
}

