/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.mixin;

import joshie.durabilitydecay.config.ConfigManager;
import joshie.durabilitydecay.config.DecayRule;
import joshie.durabilitydecay.util.DecayData;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RepairItemRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RepairItemRecipe.class})
public class RepairItemRecipeMixin {
    @Inject(method={"assemble(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void limitRepairByDecay(CraftingInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        int effectiveMaxDamage;
        int maxAllowedDamage;
        ItemStack damagedItem = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty() || !stack.isDamageableItem() || stack.getDamageValue() <= 0) continue;
            damagedItem = stack;
            break;
        }
        if (damagedItem.isEmpty()) {
            return;
        }
        int decay = DecayData.getDecay(damagedItem);
        if (decay <= 0) {
            return;
        }
        DecayRule rule = ConfigManager.getInstance().getConfig().getRuleForItem(damagedItem);
        if (rule == null) {
            return;
        }
        int maxDamage = damagedItem.getMaxDamage();
        int currentDamage = damagedItem.getDamageValue();
        if (currentDamage <= (maxAllowedDamage = maxDamage - (effectiveMaxDamage = maxDamage - decay))) {
            cir.setReturnValue((Object)ItemStack.EMPTY);
        }
    }
}

