/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.util;

import joshie.durabilitydecay.config.ConfigManager;
import joshie.durabilitydecay.config.DecayRule;
import joshie.durabilitydecay.util.DecayData;
import net.minecraft.world.item.ItemStack;

public class DecayCalculator {
    public static void applyDecay(ItemStack stack, int repairedAmount, boolean isMending) {
        if (stack.isEmpty() || !stack.isDamageableItem() || repairedAmount <= 0) {
            return;
        }
        DecayRule rule = ConfigManager.getInstance().getConfig().getRuleForItem(stack);
        if (rule == null) {
            return;
        }
        if (isMending && !rule.mendingImpactsBlock) {
            return;
        }
        int currentDecay = DecayData.getDecay(stack);
        int maxDurability = stack.getMaxDamage();
        int decayToAdd = rule.calculateDecay(repairedAmount, maxDurability, currentDecay);
        if (decayToAdd > 0) {
            DecayData.addDecay(stack, decayToAdd);
        }
    }

    public static int calculateRepairedAmount(int damageBefore, int damageAfter) {
        return Math.max(0, damageBefore - damageAfter);
    }

    public static boolean shouldApplyDecay(ItemStack stack) {
        if (stack.isEmpty() || !stack.isDamageableItem()) {
            return false;
        }
        return ConfigManager.getInstance().getConfig().shouldApplyDecay(stack);
    }
}

