/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.util;

import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class DecayData {
    private static final String NBT_KEY = "durability_decay";
    private static final String DECAY_VALUE_KEY = "accumulated_decay";

    public static int getDecay(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag == null || !tag.contains(NBT_KEY)) {
            return 0;
        }
        CompoundTag decayTag = tag.getCompound(NBT_KEY);
        return decayTag.getInt(DECAY_VALUE_KEY);
    }

    public static void setDecay(ItemStack stack, int decay) {
        if (stack.isEmpty()) {
            return;
        }
        int maxDamage = stack.getMaxDamage();
        decay = Math.max(0, Math.min(decay, maxDamage));
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        CompoundTag decayTag = tag.getCompound(NBT_KEY);
        if (!tag.contains(NBT_KEY)) {
            tag.put(NBT_KEY, (Tag)decayTag);
        }
        decayTag.putInt(DECAY_VALUE_KEY, decay);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static void addDecay(ItemStack stack, int additionalDecay) {
        int currentDecay = DecayData.getDecay(stack);
        DecayData.setDecay(stack, currentDecay + additionalDecay);
    }

    public static int getEffectiveMaxDurability(ItemStack stack) {
        int maxDamage = stack.getMaxDamage();
        int decay = DecayData.getDecay(stack);
        return Math.max(1, maxDamage - decay);
    }

    public static float getDecayFraction(ItemStack stack) {
        int maxDamage = stack.getMaxDamage();
        if (maxDamage <= 0) {
            return 0.0f;
        }
        return (float)DecayData.getDecay(stack) / (float)maxDamage;
    }

    public static boolean canBeRepaired(ItemStack stack) {
        return DecayData.getEffectiveMaxDurability(stack) > 1;
    }
}

