/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import homeostatic.common.Hydration;
import java.lang.reflect.Type;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public record DrinkableItem(class_2960 loc, int amount, float saturation, int potency, int duration, float chance) {
    public static Hydration getHydration(DrinkableItem item) {
        return new Hydration(item.amount(), item.saturation(), item.potency(), item.duration(), item.chance());
    }

    public static class Serializer
    implements JsonDeserializer<DrinkableItem>,
    JsonSerializer<DrinkableItem> {
        public DrinkableItem deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"data");
            return new DrinkableItem(class_2960.method_60654((String)json.get("type").getAsString()), json.get("amount").getAsInt(), json.get("saturation").getAsFloat(), json.get("effect_potency").getAsInt(), json.get("effect_duration").getAsInt(), json.get("effect_chance").getAsFloat());
        }

        public JsonElement serialize(DrinkableItem drinkableItem, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("type", drinkableItem.loc().toString());
            json.addProperty("amount", (Number)drinkableItem.amount());
            json.addProperty("saturation", (Number)Float.valueOf(drinkableItem.saturation()));
            json.addProperty("effect_potency", (Number)drinkableItem.potency());
            json.addProperty("effect_duration", (Number)drinkableItem.duration());
            json.addProperty("effect_chance", (Number)Float.valueOf(drinkableItem.chance()));
            return json;
        }
    }
}

