/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.TagManager;
import homeostatic.common.item.DrinkableItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class DrinkableItemManager
extends class_4309 {
    private static final Map<class_1792, DrinkableItem> ITEMS = new HashMap<class_1792, DrinkableItem>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkableItem.class, (Object)new DrinkableItem.Serializer()).create();
    private static final DrinkableItem FRUIT = new DrinkableItem(TagManager.Items.FRUITS.comp_327(), 2, 0.6f, 0, 0, 0.0f);
    private static final DrinkableItem ROOT_VEGETABLE = new DrinkableItem(TagManager.Items.ROOT_VEGETABLES.comp_327(), 1, 0.1f, 0, 0, 0.0f);
    private static final DrinkableItem VEGETABLE = new DrinkableItem(TagManager.Items.VEGETABLES.comp_327(), 1, 0.1f, 0, 0, 0.0f);

    public DrinkableItemManager() {
        super(GSON, "environment/drinkable");
    }

    public static JsonElement parseDrinkableItem(DrinkableItem drinkableItem) {
        return GSON.toJsonTree((Object)drinkableItem);
    }

    public static DrinkableItem get(class_1799 stack) {
        DrinkableItem drinkableItem = ITEMS.get(stack.method_7909());
        if (drinkableItem != null) {
            return drinkableItem;
        }
        if (stack.method_31573(TagManager.Items.FRUITS)) {
            return FRUIT;
        }
        if (stack.method_31573(TagManager.Items.ROOT_VEGETABLES)) {
            return ROOT_VEGETABLE;
        }
        if (stack.method_31573(TagManager.Items.VEGETABLES)) {
            return VEGETABLE;
        }
        return null;
    }

    protected void apply(Map<class_2960, JsonElement> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        ITEMS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkableItem drinkableItem = (DrinkableItem)GSON.fromJson(entry.getValue(), DrinkableItem.class);
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(drinkableItem.loc());
                if (item == class_1802.field_8162) continue;
                ITEMS.put(item, drinkableItem);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinkable item {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} drinkable items", (Object)ITEMS.size());
    }
}

