/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import homeostatic.data.BiomeCategoryProvider;
import homeostatic.data.DrinkableItemsProvider;
import homeostatic.data.DrinkingFluidsProvider;
import homeostatic.data.FabricBlockTagProvider;
import homeostatic.data.HomeostaticFluidTagsProvider;
import homeostatic.data.HomeostaticItemModelProvider;
import homeostatic.data.HomeostaticItemTagsProvider;
import homeostatic.data.HomeostaticLanguageProvider;
import homeostatic.data.HomeostaticRecipeProvider;
import homeostatic.data.RadiationBlocksProvider;
import homeostatic.data.recipe.CommonRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_7784;

public class FabricDatagenInitializer
implements DataGeneratorEntrypoint {
    private static FabricTagProvider.BlockTagProvider fabricBlockTagProvider;

    public void onInitializeDataGenerator(FabricDataGenerator gen) {
        FabricDataGenerator.Pack pack = gen.createPack();
        fabricBlockTagProvider = (FabricTagProvider.BlockTagProvider)pack.addProvider(FabricBlockTagProvider::new);
        if (System.getProperty("homeostatic.common_datagen") != null) {
            FabricDatagenInitializer.configureCommonDatagen(pack);
        } else {
            FabricDatagenInitializer.configureFabricDatagen(pack);
        }
    }

    public static void configureCommonDatagen(FabricDataGenerator.Pack pack) {
        pack.addProvider((dataOutput, registryFuture) -> new HomeostaticItemTagsProvider((class_7784)dataOutput, registryFuture, fabricBlockTagProvider.method_49662()));
        pack.addProvider(HomeostaticFluidTagsProvider::new);
        pack.addProvider((dataOutput, registryFuture) -> new HomeostaticItemModelProvider(dataOutput));
        pack.addProvider((dataOutput, registryFuture) -> new RadiationBlocksProvider((class_7784)dataOutput));
        pack.addProvider((dataOutput, registryFuture) -> new DrinkingFluidsProvider((class_7784)dataOutput));
        pack.addProvider((dataOutput, registryFuture) -> new DrinkableItemsProvider((class_7784)dataOutput));
        pack.addProvider((dataOutput, registryFuture) -> new BiomeCategoryProvider((class_7784)dataOutput));
        pack.addProvider(HomeostaticLanguageProvider::new);
        pack.addProvider(CommonRecipeProvider::new);
    }

    public static void configureFabricDatagen(FabricDataGenerator.Pack pack) {
        pack.addProvider(HomeostaticRecipeProvider::new);
    }
}

