/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations.jei;

import homeostatic.Homeostatic;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.recipe.ArmorEnhancement;
import homeostatic.common.recipe.HelmetThermometer;
import homeostatic.config.ConfigHandler;
import homeostatic.integrations.ArmorEnhancementRecipeMaker;
import homeostatic.integrations.HelmetThermometerRecipeMaker;
import homeostatic.integrations.WaterFilterRecipeMaker;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8786;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public class_2960 getPluginUid() {
        return Homeostatic.loc("jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        class_310 minecraft = class_310.method_1551();
        class_1863 recipeManager = Objects.requireNonNull(minecraft.field_1687).method_8433();
        List allCraftingRecipes = recipeManager.method_30027(class_3956.field_17545);
        List<class_8786<class_3955>> armorEnhancementRecipes = JEIPlugin.addArmorCraftingRecipes(allCraftingRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, armorEnhancementRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, WaterFilterRecipeMaker.getFilterCraftingRecipes("jei"));
        if (!ConfigHandler.Common.requireThermometer()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)HomeostaticItems.THERMOMETER)));
        }
    }

    private static List<class_8786<class_3955>> addArmorCraftingRecipes(List<class_8786<class_3955>> allCraftingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(ArmorEnhancement.class, () -> ArmorEnhancementRecipeMaker.createRecipes("jei"));
        if (ConfigHandler.Common.requireThermometer()) {
            replacers.put(HelmetThermometer.class, () -> HelmetThermometerRecipeMaker.createRecipes("jei"));
        }
        return allCraftingRecipes.stream().map(class_8786::comp_1933).map(class_3955::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new class_8786[0]);
            }
        }).toList();
    }
}

