/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import homeostatic.common.temperature.TemperatureDirection;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.Overlay;
import homeostatic.platform.Services;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.FontHelper;
import homeostatic.util.TempHelper;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_746;

public class TemperatureInfo
extends Overlay {
    @Override
    public void render(class_332 guiGraphics, class_310 mc, class_2338 pos, int scaledWidth, int scaledHeight) {
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        Services.PLATFORM.getTemperatureData((class_1657)player).ifPresent(data -> {
            TemperatureDirection skinTemperatureDirection = TempHelper.getSkinTemperatureDirection(data.getLocalTemperature(), data.getSkinTemperature());
            TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(data.getLastSkinTemperature(), data.getCoreTemperature(), data.getSkinTemperature());
            String skinIcon = skinTemperatureDirection.icon;
            String coreIcon = coreTemperatureDirection.icon;
            String localTemp = String.format(" %.2f", TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
            String skinTemp = String.format("s: %.2f%s", TempHelper.convertMcTemp(data.getSkinTemperature(), ConfigHandler.Client.useFahrenheit()), skinIcon);
            String coreTemp = String.format(" c: %.2f%s ", TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()), coreIcon);
            class_3545<TemperatureRange, Integer> localRangeStep = TempHelper.getLocalTemperatureRangeStep(data.getLocalTemperature());
            class_3545<TemperatureRange, Integer> coreRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getCoreTemperature());
            class_3545<TemperatureRange, Integer> skinRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getSkinTemperature());
            int localTempWidth = mc.field_1772.method_1727(localTemp);
            int skinTempWidth = mc.field_1772.method_1727(skinTemp);
            int coreTempWidth = mc.field_1772.method_1727(coreTemp);
            String string = ConfigHandler.Client.debugPosition();
            Objects.requireNonNull(mc.field_1772);
            int y = Alignment.getTextY(string, scaledHeight, 1, 9, ConfigHandler.Client.debugOffsetY(), 1.0f);
            FontHelper.draw(mc, guiGraphics, localTemp, Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, localTempWidth, ConfigHandler.Client.debugOffsetX(), 1.0f), y, ColorHelper.getLocalTemperatureColor(localRangeStep), false);
            int n = Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, skinTempWidth, ConfigHandler.Client.debugOffsetX(), 1.0f);
            Objects.requireNonNull(mc.field_1772);
            FontHelper.draw(mc, guiGraphics, skinTemp, n, y + 9, ColorHelper.getTemperatureColor(skinRangeStep), false);
            int n2 = Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, coreTempWidth, ConfigHandler.Client.debugOffsetX(), 1.0f);
            Objects.requireNonNull(mc.field_1772);
            FontHelper.draw(mc, guiGraphics, coreTemp, n2, y + 9 * 2, ColorHelper.getTemperatureColor(coreRangeStep), false);
        });
    }
}

