/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import homeostatic.Homeostatic;
import homeostatic.common.temperature.TemperatureDirection;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.config.ConfigHandler;
import homeostatic.network.ITemperature;
import homeostatic.overlay.Overlay;
import homeostatic.platform.Services;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.FontHelper;
import homeostatic.util.TempHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class TemperatureOverlay
extends Overlay {
    public static final class_2960 SPRITE = Homeostatic.loc("textures/gui/icons.png");
    protected static final int ICON_WIDTH = 13;
    protected static final int ICON_HEIGHT = 26;

    @Override
    public void render(class_332 guiGraphics, class_310 mc, @Nullable class_2338 pos, int scaledWidth, int scaledHeight) {
        class_746 player = mc.field_1724;
        class_4587 matrix = guiGraphics.method_51448();
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)SPRITE);
        Services.PLATFORM.getTemperatureData((class_1657)player).ifPresent(arg_0 -> this.lambda$render$1(scaledWidth, scaledHeight, mc, guiGraphics, (class_1657)player, matrix, arg_0));
    }

    private int getTempLineOffset(class_3545<TemperatureRange, Integer> rangeStep) {
        TemperatureRange range = (TemperatureRange)((Object)rangeStep.method_15442());
        int step = (Integer)rangeStep.method_15441() / 2;
        int offset = range == TemperatureRange.COLD ? Math.max(7 - step, 1) : Math.min(8 + step, 15);
        return offset;
    }

    private /* synthetic */ void lambda$render$1(int scaledWidth, int scaledHeight, class_310 mc, class_332 guiGraphics, class_1657 player, class_4587 matrix, ITemperature data) {
        int offsetX = Alignment.getX(ConfigHandler.Client.thermometerPosition(), scaledWidth, 13, ConfigHandler.Client.thermometerOffsetX());
        int pY = Alignment.getY(ConfigHandler.Client.thermometerPosition(), scaledHeight, ConfigHandler.Client.thermometerOffsetY());
        float textScale = 0.5f;
        TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(data.getLastSkinTemperature(), data.getCoreTemperature(), data.getSkinTemperature());
        TemperatureDirection skinTemperatureDirection = TempHelper.getSkinTemperatureDirection(data.getLocalTemperature(), data.getSkinTemperature());
        String coreDirection = coreTemperatureDirection.icon;
        String skinDirection = skinTemperatureDirection.icon;
        String coreTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.1f\u00b0" : "%.1f";
        String localTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.0f\u00b0" : "%.0f";
        String coreTempSmall = String.format(coreTempFormat, TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()));
        String localTemp = String.format(localTempFormat, TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
        int textOffsetX = Alignment.getIconTextX(ConfigHandler.Client.thermometerPosition(), scaledWidth, mc.field_1772.method_1727(coreTempSmall), ConfigHandler.Client.thermometerOffsetX(), textScale, 13);
        int localTextOffsetX = Alignment.getIconTextX(ConfigHandler.Client.thermometerPosition(), scaledWidth, mc.field_1772.method_1727(localTemp), ConfigHandler.Client.thermometerOffsetX(), textScale, 13);
        int textOffsetY = Alignment.getIconTextY(ConfigHandler.Client.thermometerPosition(), scaledHeight, ConfigHandler.Client.thermometerTextOffsetY(), textScale);
        int directionOffsetX = Alignment.getIconTextX(ConfigHandler.Client.thermometerPosition(), scaledWidth, mc.field_1772.method_1727(coreDirection), ConfigHandler.Client.thermometerOffsetX(), textScale, 13);
        int pV = 0;
        int pUOffset = 53;
        class_3545<TemperatureRange, Integer> localRangeStep = TempHelper.getLocalTemperatureRangeStep(data.getLocalTemperature());
        class_3545<TemperatureRange, Integer> coreRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getCoreTemperature());
        class_3545<TemperatureRange, Integer> skinRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getSkinTemperature());
        int lineOffset = this.getTempLineOffset(coreRangeStep);
        AtomicBoolean showTemperature = new AtomicBoolean(ConfigHandler.Common.showTemperatureValues());
        if (data.getCoreTemperature() > TemperatureThreshold.WARNING_HIGH.temperature) {
            guiGraphics.method_25302(SPRITE, offsetX, pY, pUOffset, pV + 26, 13, 26);
        } else if (data.getCoreTemperature() < TemperatureThreshold.WARNING_LOW.temperature) {
            guiGraphics.method_25302(SPRITE, offsetX, pY, pUOffset, pV + 52, 13, 26);
        } else {
            guiGraphics.method_25302(SPRITE, offsetX, pY, pUOffset, pV, 13, 26);
        }
        guiGraphics.method_25302(SPRITE, offsetX, pY, pUOffset + 13, pV + lineOffset, 13, 26);
        if (ConfigHandler.Common.requireThermometer()) {
            Services.PLATFORM.getThermometerCapability(player).ifPresent(thermometer -> showTemperature.set(thermometer.hasThermometer()));
        }
        matrix.method_22905(textScale, textScale, textScale);
        if (ConfigHandler.Client.showThermometerRateChangeSymbols()) {
            FontHelper.draw(mc, guiGraphics, coreDirection, directionOffsetX - 8, textOffsetY - 15, ColorHelper.getLocalTemperatureColor(coreRangeStep), true);
            FontHelper.draw(mc, guiGraphics, skinDirection, directionOffsetX + 8, textOffsetY - 15, ColorHelper.getLocalTemperatureColor(skinRangeStep), true);
        }
        if (showTemperature.get()) {
            FontHelper.draw(mc, guiGraphics, localTemp, localTextOffsetX, textOffsetY - 50, ColorHelper.getLocalTemperatureColor(localRangeStep), true);
            FontHelper.draw(mc, guiGraphics, coreTempSmall, textOffsetX, textOffsetY, ColorHelper.getTemperatureColor(coreRangeStep), true);
        }
    }
}

