/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.platform;

import homeostatic.common.biome.ClimateSettings;
import homeostatic.common.components.HomeostaticCardinalComponents;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.item.IItemStackFluid;
import homeostatic.common.item.LeatherFlask;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.SubSeason;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.common.water.WaterInfo;
import homeostatic.common.wetness.WetnessInfo;
import homeostatic.mixin.FabricBiomeAccessor;
import homeostatic.mixin.ServerLevelAccessor;
import homeostatic.network.ITemperature;
import homeostatic.network.IThermometer;
import homeostatic.network.IWater;
import homeostatic.network.IWetness;
import homeostatic.platform.services.IPlatform;
import homeostatic.util.CreateHelper;
import homeostatic.util.FabricSeasonsHelper;
import homeostatic.util.ItemStackFluidHelper;
import homeostatic.util.SereneSeasonsFabricHelper;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_5268;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public class FabricPlatform
implements IPlatform {
    @Override
    public class_2960 getFluidResourceLocation(class_3611 fluid) {
        return class_7923.field_41173.method_10221((Object)fluid);
    }

    @Override
    public boolean isModLoaded(String name) {
        return FabricLoader.getInstance().isModLoaded(name);
    }

    @Override
    public boolean isPhysicalClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public double getCreateBlockRadiation(class_2680 state, Double radiation) {
        return CreateHelper.getBlockRadiation(state, radiation);
    }

    @Override
    public String fluidStackTag() {
        return "Fluid";
    }

    @Override
    public Optional<FluidInfo> getFluidInfo(class_1799 stack) {
        if (stack.method_7909() instanceof IItemStackFluid) {
            return Optional.of(ItemStackFluidHelper.getFluidInfo(stack));
        }
        return Optional.empty();
    }

    @Override
    public class_1799 drainFluid(class_1799 stack, long amount) {
        if (stack.method_7909() instanceof IItemStackFluid) {
            ItemStackFluidHelper.drainFluid(stack, amount);
        }
        return stack;
    }

    @Override
    public class_1799 fillFluid(class_1799 stack, class_3611 fluid, long amount) {
        if (stack.method_7909() instanceof IItemStackFluid) {
            ItemStackFluidHelper.fillFluid(stack, fluid, amount);
        }
        return stack;
    }

    @Override
    public long getFluidCapacity(class_1799 stack) {
        if (stack.method_7909() instanceof LeatherFlask) {
            return 1000L;
        }
        return 0L;
    }

    @Override
    public class_2561 getDisplayName(class_3611 fluid) {
        return fluid.method_15785().method_15759().method_26204().method_9518();
    }

    @Override
    public ClimateSettings getClimateSettings(class_6880<class_1959> biomeHolder) {
        class_1959.class_5482 climateSettings = ((FabricBiomeAccessor)biomeHolder.comp_349()).homoestatic$getClimateSettings();
        return new ClimateSettings(biomeHolder, climateSettings.comp_1187(), climateSettings.comp_844(), climateSettings.comp_845(), climateSettings.comp_846());
    }

    @Override
    public SubSeason getSubSeason(class_3218 level, class_6880<class_1959> biomeHolder) {
        if (this.isModLoaded("sereneseasons") && SereneSeasonsFabricHelper.isSeasonDimension((class_1937)level)) {
            return SereneSeasonsFabricHelper.getSubSeason((class_1937)level);
        }
        if (this.isModLoaded("seasons") && FabricSeasonsHelper.isSeasonDimension((class_1937)level)) {
            return SubSeason.getSubSeason((class_1937)level, FabricSeasonsHelper.getSeasonDuration());
        }
        return null;
    }

    @Override
    public Optional<? extends ITemperature> getTemperatureData(class_1657 player) {
        return HomeostaticCardinalComponents.TEMPERATURE_DATA.maybeGet((Object)player);
    }

    @Override
    public void syncTemperatureData(class_3222 sp, EnvironmentData environmentData, BodyTemperature bodyTemperature) {
        HomeostaticCardinalComponents.TEMPERATURE_DATA.sync((Object)sp);
    }

    @Override
    public Optional<? extends IThermometer> getThermometerCapability(class_1657 player) {
        return HomeostaticCardinalComponents.THERMOMETER_DATA.maybeGet((Object)player);
    }

    @Override
    public void syncThermometerData(class_3222 sp, ThermometerInfo info) {
        HomeostaticCardinalComponents.THERMOMETER_DATA.sync((Object)sp);
    }

    @Override
    public Optional<? extends IWater> getWaterCapabilty(class_1657 player) {
        return HomeostaticCardinalComponents.WATER_DATA.maybeGet((Object)player);
    }

    @Override
    public void syncWaterData(class_3222 sp, WaterInfo waterInfo) {
        HomeostaticCardinalComponents.WATER_DATA.sync((Object)sp);
    }

    @Override
    public Optional<? extends IWetness> getWetnessCapability(class_1657 player) {
        return HomeostaticCardinalComponents.WETNESS_DATA.maybeGet((Object)player);
    }

    @Override
    public void syncWetnessData(class_3222 sp, WetnessInfo wetnessInfo) {
        HomeostaticCardinalComponents.WETNESS_DATA.sync((Object)sp);
    }

    @Override
    public class_5268 getServerLevelData(class_3218 level) {
        ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
        return serverLevel.getServerLevelData();
    }

    @Override
    public <T> void registerDataComponent(class_2960 name, class_9331<T> component) {
        class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)name, component);
    }
}

