/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun;

import com.jdolphin.portalgun.config.PortalGunCommonConfig;
import com.jdolphin.portalgun.init.ModBlocks;
import com.jdolphin.portalgun.init.ModEntities;
import com.jdolphin.portalgun.init.ModItems;
import com.jdolphin.portalgun.init.ModPackets;
import com.jdolphin.portalgun.init.ModSounds;
import com.jdolphin.portalgun.util.KeyBinds;
import com.jdolphin.portalgun.util.helpers.Helper;
import com.mojang.logging.LogUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.slf4j.Logger;

@Mod(value="ricksportalgun")
public class PortalGunMod {
    public static final String MODID = "ricksportalgun";
    private static final Logger LOGGER = LogUtils.getLogger();

    public PortalGunMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PortalGunCommonConfig.SPEC, "portalgun-common.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModPackets::init);
        Helper.makeBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)Potions.f_43584_)}), Items.f_42730_, (Item)ModItems.QUANTUM_LEAP_ELIXIR.get());
        Helper.makeBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)Potions.f_43601_)}), Items.f_42545_, (Item)ModItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get());
        Helper.makeBrewingRecipe((Item)ModItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get(), (Item)ModItems.QUANTUM_LEAP_ELIXIR.get(), (Item)ModItems.PORTAL_FLUID_BOTTLE.get());
        Helper.makeBrewingRecipe((Item)ModItems.QUANTUM_LEAP_ELIXIR.get(), (Item)ModItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get(), (Item)ModItems.PORTAL_FLUID_BOTTLE.get());
    }

    @SubscribeEvent
    public void missingMappings(MissingMappingsEvent event) {
        String path;
        ResourceLocation regName;
        for (MissingMappingsEvent.Mapping entityMapping : event.getMappings(Registry.f_122903_, "portalgun")) {
            regName = entityMapping.getKey();
            if (regName == null) continue;
            path = regName.m_135815_();
            ModEntities.ENTITIES.getEntries().stream().filter(thing -> thing.getId().m_135815_().equals(path)).forEach(entity -> entityMapping.remap((Object)((EntityType)entity.get())));
        }
        for (MissingMappingsEvent.Mapping entityMapping : event.getMappings(Registry.f_122904_, "portalgun")) {
            regName = entityMapping.getKey();
            if (regName == null) continue;
            path = regName.m_135815_();
            ModItems.ITEMS.getEntries().stream().filter(thing -> thing.getId().m_135815_().equals(path)).forEach(item -> entityMapping.remap((Object)((Item)item.get())));
        }
    }

    @Mod.EventBusSubscriber(modid="ricksportalgun", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(KeyBinds.KEY_PORTAL_MENU);
        }
    }
}

