/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.client.gui;

import com.google.common.collect.ImmutableList;
import com.jdolphin.portalgun.client.gui.CreateWaypointScreen;
import com.jdolphin.portalgun.client.gui.WaypointInfoScreen;
import com.jdolphin.portalgun.init.ModPackets;
import com.jdolphin.portalgun.init.ModTags;
import com.jdolphin.portalgun.item.PortalGunItem;
import com.jdolphin.portalgun.packets.SBManageWaypointsPacket;
import com.jdolphin.portalgun.util.Waypoint;
import com.jdolphin.portalgun.util.helpers.GuiHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WaypointScreen
extends Screen {
    public WaypointList waypointList;

    public WaypointScreen() {
        super((Component)Component.m_237115_((String)"menu.ricksportalgun.waypoints"));
    }

    protected void m_7856_() {
        super.m_7856_();
        assert (this.f_96541_ != null && this.f_96541_.f_91080_ != null && this.f_96541_.f_91074_ != null);
        LocalPlayer player = this.f_96541_.f_91074_;
        this.m_142416_((GuiEventListener)new ImageButton(this.f_96543_ / 2 + 68, 26, 20, 20, 0, 37, 20, GuiHelper.BUTTONS_LOCATION, 256, 256, button -> this.f_96541_.m_91152_((Screen)new CreateWaypointScreen()), (pButton, pPoseStack, pMouseX, pMouseY) -> this.f_96541_.f_91080_.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.new"), pMouseX, pMouseY), (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.new")));
        ItemStack stack = player.m_21120_(player.m_7655_());
        if (stack.m_204117_(ModTags.Items.PORTAL_GUNS)) {
            this.waypointList = new WaypointList(this, this.f_96541_, stack);
            this.m_7787_((GuiEventListener)this.waypointList);
        }
    }

    public void m_6305_(@NotNull PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        if (this.waypointList != null) {
            this.waypointList.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        GuiComponent.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.saved"), (int)(this.f_96543_ / 2), (int)30, (int)Color.WHITE.getRGB());
        assert (this.f_96541_ != null);
        Style style = GuiHelper.getStyle(this, pMouseX, pMouseY);
        if (style != null && style.m_131186_() != null) {
            this.m_96570_(pPoseStack, style, pMouseX, pMouseY);
        }
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public static class WaypointList
    extends ContainerObjectSelectionList<Entry> {
        public final ItemStack stack;
        public final PortalGunItem item;

        public WaypointList(WaypointScreen waypointScreen, Minecraft minecraft, ItemStack stack) {
            super(minecraft, waypointScreen.f_96543_, waypointScreen.f_96544_, 58, waypointScreen.f_96544_ - 32, 24);
            this.m_93488_(false);
            this.m_93496_(false);
            this.stack = stack;
            this.item = (PortalGunItem)stack.m_41720_();
            List<String> waypoints = PortalGunItem.getWaypoints(stack);
            for (String str : waypoints) {
                Waypoint waypoint = Waypoint.getWaypoint(str);
                if (waypoint == null) {
                    LogManager.getLogger().warn("Failed to get Waypoint: {}", (Object)str);
                    continue;
                }
                if (waypoint.getName() == null) {
                    LogManager.getLogger().warn("Waypoint at {} in dim {} has null name", (Object)waypoint.getBlockPos(), (Object)waypoint.getDim());
                    continue;
                }
                this.m_7085_((AbstractSelectionList.Entry)new WaypointEntry(waypoint, this));
            }
        }

        protected int m_5756_() {
            return super.m_5756_() - 32;
        }

        public int m_5759_() {
            return super.m_5759_() - 32;
        }

        public static class WaypointEntry
        extends Entry {
            private final Waypoint waypoint;
            private final Button button;
            private final Button infoButton;
            protected WaypointList f_93521_;

            WaypointEntry(Waypoint waypoint, WaypointList list) {
                this.waypoint = waypoint;
                this.f_93521_ = list;
                this.button = new Button(16, 0, 128, 20, (Component)Component.m_237113_((String)waypoint.getName()), pButton -> {
                    SBManageWaypointsPacket packet = new SBManageWaypointsPacket(waypoint.getBlockPos(), waypoint.getDim(), waypoint.getName(), false);
                    ModPackets.INSTANCE.sendToServer((Object)packet);
                    list.f_93386_.m_91152_(null);
                });
                this.infoButton = new ImageButton(0, 0, 20, 20, 20, 37, 20, GuiHelper.BUTTONS_LOCATION, 256, 256, button -> list.f_93386_.m_91152_((Screen)new WaypointInfoScreen((Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.info"), waypoint)), (pButton, pPoseStack, pMouseX, pMouseY) -> {
                    assert (((WaypointList)list).f_93386_.f_91080_ != null);
                    ((WaypointList)list).f_93386_.f_91080_.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.info"), pMouseX, pMouseY);
                }, (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.info"));
            }

            public void m_6311_(@NotNull PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                WaypointList wpList = this.f_93521_;
                if (pTop > wpList.f_93390_ && pTop + wpList.f_93387_ < wpList.f_93389_ - wpList.f_93387_) {
                    this.button.f_93620_ = wpList.getWidth() / 2 - 64;
                    this.button.f_93621_ = pTop;
                    this.button.m_93666_((Component)Component.m_237113_((String)this.waypoint.getName()));
                    this.infoButton.f_93620_ = wpList.getWidth() / 2 + 68;
                    this.infoButton.f_93621_ = pTop;
                    GuiHelper.renderWidgets(pPoseStack, pMouseX, pMouseY, pPartialTick, new Widget[]{this.button, this.infoButton});
                }
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return ImmutableList.of((Object)this.button, (Object)this.infoButton);
            }

            @NotNull
            public List<? extends GuiEventListener> m_6702_() {
                return ImmutableList.of((Object)this.button, (Object)this.infoButton);
            }

            public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                if (this.button.m_6375_(pMouseX, pMouseY, pButton)) {
                    return true;
                }
                return this.infoButton.m_6375_(pMouseX, pMouseY, pButton);
            }

            public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
                return this.button.m_6348_(pMouseX, pMouseY, pButton) || this.infoButton.m_6348_(pMouseX, pMouseY, pButton);
            }
        }

        public static abstract class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
        }
    }
}

