/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.client.renderer;

import com.jdolphin.portalgun.client.model.PortalEntityModel;
import com.jdolphin.portalgun.entity.PortalEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PortalEntityRenderer
extends EntityRenderer<PortalEntity> {
    private final PortalEntityModel<PortalEntity> model;
    public static final ResourceLocation PORTAL_TEXTURE = new ResourceLocation("ricksportalgun", "textures/entity/portal.png");

    public PortalEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PortalEntityModel(context.m_174023_(PortalEntityModel.LAYER_LOCATION));
    }

    public void render(PortalEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        float f = 0.0f;
        if (pEntity.f_19797_ <= 5) {
            f = 0.25f;
        }
        if (pEntity.f_19797_ >= 6 && pEntity.f_19797_ <= 10) {
            f = 0.5f;
        }
        if (pEntity.f_19797_ >= 11 && pEntity.f_19797_ <= 15) {
            f = 0.75f;
        }
        if (pEntity.f_19797_ >= 16) {
            f = 1.0f;
        }
        if (pEntity.f_19797_ >= 185 && pEntity.f_19797_ <= 190) {
            f = 0.75f;
        }
        if (pEntity.f_19797_ >= 191 && pEntity.f_19797_ <= 195) {
            f = 0.5f;
        }
        if (pEntity.f_19797_ >= 196) {
            f = 0.25f;
        }
        pMatrixStack.m_85841_(f, f, f);
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19859_, (float)pEntity.m_146908_()) - 180.0f));
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)PORTAL_TEXTURE));
        Color color = new Color(pEntity.getColor());
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        this.model.m_7695_(pMatrixStack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, r, g, b, 1.0f);
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull PortalEntity pEntity) {
        return PORTAL_TEXTURE;
    }
}

