/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.item;

import com.jdolphin.portalgun.entity.PortalEntity;
import com.jdolphin.portalgun.init.ModEntities;
import com.jdolphin.portalgun.init.ModItems;
import com.jdolphin.portalgun.init.ModTags;
import com.jdolphin.portalgun.util.Waypoint;
import com.jdolphin.portalgun.util.helpers.LevelHelper;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PortalGunItem
extends Item {
    public static final String TAG_DIMENSION = "PortalDimension";
    public static final String TAG_BPOS = "PortalPos";
    public static final String TAG_ACIDIC = "Bootleg";
    public static final String TAG_COLOR = "Color";
    public static final String TAG_WAYPOINTS = "Wayoints";
    public static final String TAG_LOCK = "Lock";
    public static final String TAG_BIG = "Big";
    public static final String TAG_OWNER = "Owner";
    public static final String TAG_DEFAULT_COLOR = "DefaultColor";
    private int colour;

    public PortalGunItem(Item.Properties properties, int colour) {
        super(properties);
        this.colour = colour;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        BlockHitResult hitResult = PortalGunItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            this.setDefaultColor(stack, this.colour);
            if (!tag.m_128441_(TAG_OWNER)) {
                tag.m_128362_(TAG_OWNER, player.m_20148_());
            }
            if (tag.m_128471_(TAG_LOCK) && tag.m_128342_(TAG_OWNER).equals(player.m_20148_()) || !tag.m_128471_(TAG_LOCK)) {
                if (stack.m_41773_() < stack.m_41776_()) {
                    if (!tag.m_128441_(TAG_BPOS)) {
                        tag.m_128365_(TAG_BPOS, (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(player.m_20185_(), player.m_20186_(), player.m_20189_())));
                    }
                    if (!tag.m_128441_(TAG_DIMENSION)) {
                        tag.m_128359_(TAG_DIMENSION, "overworld");
                    }
                    if (!tag.m_128441_(TAG_ACIDIC)) {
                        tag.m_128379_(TAG_ACIDIC, false);
                    }
                    PortalEntity portal = new PortalEntity((EntityType<? extends PortalEntity>)((EntityType)ModEntities.PORTAL.get()), level);
                    PortalEntity exPortal = new PortalEntity((EntityType<? extends PortalEntity>)((EntityType)ModEntities.PORTAL.get()), level);
                    portal.m_37251_((Entity)player, 0.0f, player.m_146908_(), 0.0f, 1.0f, 0.1f);
                    exPortal.m_37251_((Entity)player, 0.0f, player.m_146908_(), 0.0f, 1.0f, 0.1f);
                    exPortal.m_6034_(PortalGunItem.getHopCoords(stack).m_123341_(), PortalGunItem.getHopCoords(stack).m_123342_(), PortalGunItem.getHopCoords(stack).m_123343_());
                    Vec3 loc = hitResult.m_82450_();
                    if (hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                        Direction dir = hitResult.m_82434_();
                        BlockPos bPos = hitResult.m_82425_();
                        if (level.m_8055_(bPos.m_7494_()).m_60713_(Blocks.f_50016_) && dir == Direction.UP) {
                            portal.m_6034_(loc.m_7096_(), loc.m_7098_(), loc.m_7094_());
                        }
                        if (level.m_8055_(bPos.m_7495_()).m_60713_(Blocks.f_50016_) && dir == Direction.DOWN) {
                            portal.m_6034_(loc.m_7096_(), loc.m_7098_() - 2.0, loc.m_7094_());
                        }
                        if (dir == Direction.NORTH) {
                            if (level.m_8055_(bPos.m_122012_()).m_60713_(Blocks.f_50016_)) {
                                portal.m_6034_((double)bPos.m_123341_() + 0.5, bPos.m_123342_() - 1, (double)bPos.m_123343_() - 0.5);
                            } else {
                                portal.m_6034_(loc.m_7096_(), bPos.m_123342_() - 1, loc.m_7094_());
                            }
                        }
                        if (dir == Direction.SOUTH) {
                            if (level.m_8055_(bPos.m_122019_()).m_60713_(Blocks.f_50016_)) {
                                portal.m_6034_((double)bPos.m_123341_() + 0.5, bPos.m_123342_() - 1, (double)bPos.m_123343_() + 1.5);
                            } else {
                                portal.m_6034_(loc.m_7096_(), bPos.m_123342_() - 1, loc.m_7094_());
                            }
                        }
                        if (dir == Direction.WEST) {
                            if (level.m_8055_(bPos.m_122024_()).m_60713_(Blocks.f_50016_)) {
                                portal.m_6034_((double)bPos.m_123341_() - 0.5, bPos.m_123342_() - 1, (double)bPos.m_123343_() + 0.5);
                            } else {
                                portal.m_6034_(loc.m_7096_(), bPos.m_123342_() - 1, loc.m_7094_());
                            }
                        }
                        if (dir == Direction.EAST) {
                            if (level.m_8055_(bPos.m_122029_()).m_60713_(Blocks.f_50016_)) {
                                portal.m_6034_((double)bPos.m_123341_() + 1.5, bPos.m_123342_() - 1, (double)bPos.m_123343_() + 0.5);
                            } else {
                                portal.m_6034_(loc.m_7096_(), bPos.m_123342_() - 1, loc.m_7094_());
                            }
                        }
                    } else {
                        portal.m_6034_(loc.m_7096_(), loc.m_7098_() - 1.0, loc.m_7094_());
                    }
                    ResourceKey<Level> key = LevelHelper.getWorldKey(tag.m_128461_(TAG_DIMENSION));
                    ServerLevel serverlevel = LevelHelper.getServerWorld(level, key);
                    portal.setHopLocation(PortalGunItem.getHopDimension(stack), PortalGunItem.getHopCoords(stack));
                    exPortal.setHopLocation(level.m_220362_().m_135782_(), portal.m_20183_());
                    portal.m_20097_();
                    exPortal.m_20097_();
                    portal.setColor(this.getColor(stack));
                    exPortal.setColor(this.getColor(stack));
                    if (tag.m_128471_(TAG_ACIDIC)) {
                        portal.setAcid(true);
                        exPortal.setAcid(true);
                    } else if (!tag.m_128471_(TAG_ACIDIC)) {
                        portal.setAcid(false);
                        exPortal.setAcid(false);
                    }
                    if (serverlevel != null) {
                        serverlevel.m_7967_((Entity)exPortal);
                        level.m_7967_((Entity)portal);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        player.m_36335_().m_41524_((Item)this, 60);
                        if (!player.m_7500_()) {
                            stack.m_220157_(1, level.f_46441_, null);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237113_((String)"Error 404: Destination level not found!").m_130940_(ChatFormatting.RED), false);
                    }
                }
                if (this.isDamaged(stack) && player.m_21206_().m_41720_().equals(ModItems.PORTAL_FLUID_BOTTLE.get()) && player.m_21205_().m_204117_(ModTags.Items.PORTAL_GUNS)) {
                    player.m_21205_().m_41720_().setDamage(player.m_21205_(), 0);
                    player.m_21206_().m_41774_(1);
                    tag.m_128379_(TAG_ACIDIC, false);
                }
                if (this.isDamaged(stack) && player.m_21206_().m_41720_().equals(ModItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get()) && player.m_21205_().m_204117_(ModTags.Items.PORTAL_GUNS)) {
                    player.m_21205_().m_41720_().setDamage(player.m_21120_(InteractionHand.MAIN_HAND), 0);
                    tag.m_128379_(TAG_ACIDIC, true);
                    player.m_21206_().m_41774_(1);
                }
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (PortalGunItem.getHopCoords(pStack) != null && PortalGunItem.getHopDimension(pStack) != null) {
            pTooltipComponents.add((Component)Component.m_237113_((String)("Destination: " + PortalGunItem.getHopCoords(pStack).m_123341_() + ", " + PortalGunItem.getHopCoords(pStack).m_123342_() + ", " + PortalGunItem.getHopCoords(pStack).m_123343_())).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237113_((String)("Dimension: " + PortalGunItem.getHopDimension(pStack))).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public int m_142159_(ItemStack pStack) {
        return Color.GREEN.getRGB();
    }

    public void setDefaultColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(TAG_DEFAULT_COLOR, color);
        stack.m_41739_(tag);
    }

    public void addWaypoint(CompoundTag tag, Waypoint waypoint) {
        ListTag listtag = tag.m_128437_(TAG_WAYPOINTS, 8);
        listtag.add((Object)StringTag.m_129297_((String)waypoint.getWaypointString()));
        tag.m_128365_(TAG_WAYPOINTS, (Tag)listtag);
    }

    public void deleteWaypoint(CompoundTag tag, Waypoint waypoint) {
        ListTag listtag = tag.m_128437_(TAG_WAYPOINTS, 8);
        listtag.remove((Object)StringTag.m_129297_((String)waypoint.getWaypointString()));
        tag.m_128365_(TAG_WAYPOINTS, (Tag)listtag);
    }

    public static List<String> getWaypoints(ItemStack itemStack) {
        return itemStack.m_41784_().m_128437_(TAG_WAYPOINTS, 8).stream().map(Tag::m_7916_).toList();
    }

    public int getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_COLOR) && tag.m_128441_(TAG_DEFAULT_COLOR)) {
            return tag.m_128451_(TAG_DEFAULT_COLOR);
        }
        return tag.m_128451_(TAG_COLOR);
    }

    public void setColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(TAG_COLOR, color);
        stack.m_41739_(tag);
    }

    public void setHopLocation(ItemStack itemStack, String dimension, BlockPos pos) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_(TAG_DIMENSION, dimension);
        tag.m_128365_(TAG_BPOS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        itemStack.m_41739_(tag);
    }

    public static ResourceLocation getHopDimension(ItemStack itemStack) {
        return new ResourceLocation(itemStack.m_41784_().m_128461_(TAG_DIMENSION));
    }

    public static BlockPos getHopCoords(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(TAG_BPOS)) {
            return NbtUtils.m_129239_((CompoundTag)((CompoundTag)Objects.requireNonNull(tag.m_128423_(TAG_BPOS))));
        }
        return BlockPos.f_121853_;
    }
}

