/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.packets;

import com.jdolphin.portalgun.init.ModTags;
import com.jdolphin.portalgun.item.PortalGunItem;
import com.jdolphin.portalgun.util.helpers.Helper;
import com.jdolphin.portalgun.util.helpers.LevelHelper;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkEvent;

public class SBCoordCheckPacket {
    BlockPos pos;

    public SBCoordCheckPacket(BlockPos position) {
        this.pos = position;
    }

    public SBCoordCheckPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        ServerPlayer player = context.getSender();
        assert (player != null);
        player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"notice.ricksportalgun.randomizer_find_y.start").m_130940_(ChatFormatting.YELLOW)));
        ServerLevel level = (ServerLevel)player.f_19853_;
        ItemStack stack = player.m_21205_();
        PortalGunItem item = Helper.getPortalGun(stack);
        try {
            BlockState blockState;
            int y;
            int direction;
            ChunkAccess chunk = level.m_46865_(this.pos);
            level.m_7726_().m_62227_(chunk.m_7697_().m_45610_(), chunk.m_7697_().m_45612_(), true);
            BlockPos pos = this.pos;
            int height = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            int worldCenter = (level.m_141937_() + 2 + height) / 2;
            int n = direction = y > worldCenter ? -1 : 1;
            for (y = pos.m_123342_(); y >= level.m_141937_() + 2 && y <= level.m_151558_(); y += direction) {
                BlockPos pos1 = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                BlockState blockState2 = level.m_8055_(pos1);
                BlockState belowState = level.m_8055_(pos1.m_7495_());
                BlockState aboveState = level.m_8055_(pos1.m_7494_());
                if (!belowState.m_60713_(Blocks.f_50016_) && !aboveState.m_204336_(ModTags.Blocks.DANGEROUS_BLOCKS) && !blockState2.m_60828_((BlockGetter)level, pos1)) break;
            }
            if ((blockState = level.m_8055_(pos = new BlockPos(pos.m_123341_(), y, pos.m_123343_()))).m_60828_((BlockGetter)level, pos) || blockState.m_204336_(ModTags.Blocks.DANGEROUS_BLOCKS) || y <= level.m_141937_() + 2 || y >= level.m_151558_()) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"notice.ricksportalgun.randomizer_find_y.fail").m_130940_(ChatFormatting.RED)));
                return false;
            }
            assert (item != null);
            item.setHopLocation(stack, LevelHelper.getPlayerDimensionString((Player)player), pos);
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"notice.ricksportalgun.randomizer_find_y.success").m_130940_(ChatFormatting.GREEN)));
            return true;
        }
        catch (NullPointerException err) {
            err.printStackTrace();
            return false;
        }
    }
}

