/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.packets;

import com.jdolphin.portalgun.item.PortalGunItem;
import com.jdolphin.portalgun.util.helpers.Helper;
import com.jdolphin.portalgun.util.helpers.LevelHelper;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SBLocatePlayerPacket {
    String name;

    public SBLocatePlayerPacket(String playerName) {
        this.name = playerName;
    }

    public SBLocatePlayerPacket(FriendlyByteBuf buf) {
        this.name = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        ServerPlayer player = context.getSender();
        assert (player != null);
        MinecraftServer server = player.m_20194_();
        try {
            ServerPlayer pl1 = server.m_6846_().m_11255_(this.name);
            if (pl1 != null) {
                ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
                PortalGunItem item = Helper.getPortalGun(stack);
                item.setHopLocation(stack, LevelHelper.getPlayerDimensionString((Player)pl1), pl1.m_20183_());
                Helper.sendMessage((Player)player, (Component)Component.m_237113_((String)"Coordinates set!").m_130940_(ChatFormatting.GREEN));
            } else {
                Helper.sendMessage((Player)player, (Component)Component.m_237113_((String)"Error 404: Player not found").m_130940_(ChatFormatting.RED));
            }
            return true;
        }
        catch (NullPointerException err) {
            err.printStackTrace();
            return false;
        }
    }
}

