/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.packets;

import com.jdolphin.portalgun.init.ModTags;
import com.jdolphin.portalgun.item.PortalGunItem;
import com.jdolphin.portalgun.util.Waypoint;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SBManageWaypointsPacket {
    protected BlockPos pos;
    protected String dim;
    protected String name;
    protected boolean remove;

    public SBManageWaypointsPacket(BlockPos pos, String dim, String name, boolean remove) {
        this.pos = pos;
        this.dim = dim;
        this.name = name;
        this.remove = remove;
    }

    public SBManageWaypointsPacket(FriendlyByteBuf buf) {
        this.dim = buf.m_130277_();
        this.pos = buf.m_130135_();
        this.name = buf.m_130277_();
        this.remove = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.dim);
        buf.m_130064_(this.pos);
        buf.m_130070_(this.name);
        buf.writeBoolean(this.remove);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer player = supplier.get().getSender();
        try {
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (stack.m_204117_(ModTags.Items.PORTAL_GUNS)) {
                PortalGunItem item = (PortalGunItem)stack.m_41720_();
                if (!this.remove) {
                    item.addWaypoint(stack.m_41784_(), new Waypoint(this.pos, this.dim, this.name));
                }
                if (this.remove) {
                    item.deleteWaypoint(stack.m_41784_(), new Waypoint(this.pos, this.dim, this.name));
                }
            }
            return true;
        }
        catch (NullPointerException err) {
            err.printStackTrace();
            return false;
        }
    }
}

