/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.packets;

import com.jdolphin.portalgun.item.PortalGunItem;
import com.jdolphin.portalgun.util.helpers.Helper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SBSetDestinationPacket {
    protected BlockPos pos;
    protected ResourceLocation dim;

    public SBSetDestinationPacket(BlockPos pos, ResourceLocation dim) {
        this.pos = pos;
        this.dim = dim;
    }

    public SBSetDestinationPacket(FriendlyByteBuf buf) {
        this.dim = buf.m_130281_();
        this.pos = buf.m_130135_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.dim);
        buf.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        ServerPlayer player = context.getSender();
        assert (player != null);
        try {
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            PortalGunItem item = Helper.getPortalGun(stack);
            item.setHopLocation(stack, this.dim.toString(), this.pos);
            return true;
        }
        catch (NullPointerException err) {
            err.printStackTrace();
            return false;
        }
    }
}

