/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.util;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class ModTeleporter {
    public static final HashMap<UUID, ModTeleporter> TELEPORTS = new HashMap();
    public final ResourceKey<Level> originalDim;
    public final UUID uuid;
    public final ServerLevel destLevel;
    public final Vec3 pos;
    public final float rot;

    public ModTeleporter(UUID id, ResourceKey<Level> level, ServerLevel destination, Vec3 position, float rotation) {
        this.uuid = id;
        this.originalDim = level;
        this.destLevel = destination;
        this.pos = position;
        this.rot = rotation;
    }

    public ModTeleporter(Entity e, ServerLevel level, Vec3 position, float rotation) {
        this(e.m_20148_(), (ResourceKey<Level>)e.m_9236_().m_46472_(), level, position, rotation);
    }

    public boolean tick(ServerLevel level) {
        Entity e = level.m_8791_(this.uuid);
        this.destLevel.m_46745_(new BlockPos(this.pos.m_7096_(), this.pos.m_7098_(), this.pos.m_7094_()));
        if (e instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)e;
            player.m_8999_(this.destLevel, this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, this.rot - 180.0f, player.m_146909_());
        } else if (!(e instanceof Player)) {
            e.changeDimension(this.destLevel, (ITeleporter)new EmptyTeleporter());
            e.m_146884_(this.pos);
        }
        return true;
    }

    public boolean shouldRun(ServerLevel level) {
        return level.m_46472_().m_135782_().equals((Object)this.originalDim.m_135782_());
    }

    public class EmptyTeleporter
    implements ITeleporter {
        private final Vec3 position;

        public EmptyTeleporter(Vec3 position) {
            this.position = position;
        }

        public EmptyTeleporter() {
            this(null);
        }

        public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            if (this.position != null) {
                entity.m_146884_(this.position);
            }
            return entity;
        }

        @Nullable
        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return null;
        }

        public boolean isVanilla() {
            return false;
        }

        public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
            return false;
        }
    }
}

