/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.propellerhats;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xyz.przemyk.propellerhats.items.PropellerHatItem;
import xyz.przemyk.propellerhats.network.NetworkHandler;
import xyz.przemyk.propellerhats.recipes.HatUpgradeRecipeSerializer;

@Mod(value="propellerhats")
public class PropHatsMod {
    public static final String MODID = "propellerhats";
    private static final Map<Player, Boolean> HOLDING_UP = new HashMap<Player, Boolean>();
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"propellerhats");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"propellerhats");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"propellerhats");
    public static final RegistryObject<RecipeSerializer<?>> HAT_UPGRADE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("hat_upgrade", HatUpgradeRecipeSerializer::new);
    public static final RegistryObject<PropellerHatItem> IRON_HAT = ITEMS.register("iron_hat", () -> new PropellerHatItem((ArmorMaterial)ArmorMaterials.IRON, new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41487_(1), 70000, 30, 0.1f));
    public static final RegistryObject<PropellerHatItem> GOLDEN_HAT = ITEMS.register("golden_hat", () -> new PropellerHatItem((ArmorMaterial)ArmorMaterials.GOLD, new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41487_(1), 100000, 40, 0.16f));
    public static final RegistryObject<PropellerHatItem> DIAMOND_HAT = ITEMS.register("diamond_hat", () -> new PropellerHatItem((ArmorMaterial)ArmorMaterials.DIAMOND, new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41487_(1), 500000, 150, 0.22f));
    public static final RegistryObject<PropellerHatItem> NETHERITE_HAT = ITEMS.register("netherite_hat", () -> new PropellerHatItem((ArmorMaterial)ArmorMaterials.NETHERITE, new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41487_(1), 1000000, 250, 0.3f));
    public static final RegistryObject<PropellerHatItem> CREATIVE_HAT = ITEMS.register("creative_hat", () -> new PropellerHatItem((ArmorMaterial)ArmorMaterials.NETHERITE, new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41487_(1), 1, 0, 0.3f){

        @Override
        public boolean m_142522_(ItemStack stack) {
            return false;
        }
    });
    public static final RegistryObject<SoundEvent> PROPELLER_SOUND_EVENT = SOUND_EVENTS.register("propeller", () -> new SoundEvent(new ResourceLocation(MODID, "propeller")));

    public static boolean isHoldingUp(Player playerEntity) {
        if (!HOLDING_UP.containsKey(playerEntity)) {
            HOLDING_UP.put(playerEntity, false);
        }
        return HOLDING_UP.get(playerEntity);
    }

    public static void setHoldingUp(Player playerEntity, boolean value) {
        HOLDING_UP.put(playerEntity, value);
    }

    public PropHatsMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        RECIPE_SERIALIZERS.register(bus);
        ITEMS.register(bus);
        SOUND_EVENTS.register(bus);
        NetworkHandler.registerMessages();
    }

    public static boolean isFlying(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.HEAD);
        return !stack.m_41619_() && stack.m_41720_() instanceof PropellerHatItem && PropHatsMod.isFlyingIgnoreItemType(player, stack);
    }

    public static boolean isFlyingIgnoreItemType(Player player, ItemStack stack) {
        return PropHatsMod.isHoldingUp(player) && (stack.m_41720_() == CREATIVE_HAT.get() || stack.getCapability(CapabilityEnergy.ENERGY).map(energy -> energy.getEnergyStored() > 0).orElse(false) != false);
    }
}

