/*
 * Decompiled with CFR 0.152.
 */
package net.origins.inventive_inventory.commands.config;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.origins.inventive_inventory.commands.config.type.ConfigArgumentType;
import net.origins.inventive_inventory.commands.config.type.ConfigType;
import net.origins.inventive_inventory.config.options.ConfigOption;
import net.origins.inventive_inventory.util.Notifier;

public class ConfigCommand {
    private static final String ERROR_TRANSLATION_KEY = "error.inventive_inventory.";
    private static final String NOTIFICATION_TRANSLATION_KEY = "notification.inventive_inventory.";

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 ignored) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"inventive-config").then(ConfigCommand.accessor("Sorting", ConfigType.SORTING))).then(ConfigCommand.accessor("AutomaticRefilling", ConfigType.AUTOMATIC_REFILLING))).then(ConfigCommand.accessor("Profiles", ConfigType.PROFILES)));
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> accessor(String literal, ConfigType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)literal).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"config", (ArgumentType)ConfigArgumentType.of(type)).then(ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests(ConfigCommand::suggest).executes(ConfigCommand::setConfig))))).then(ClientCommandManager.literal((String)"get").then(ClientCommandManager.argument((String)"config", (ArgumentType)ConfigArgumentType.of(type)).executes(ConfigCommand::getInfo)));
    }

    private static <T> CompletableFuture<Suggestions> suggest(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        ConfigOption<?> configOption = ConfigArgumentType.getConfig(context, "config");
        if (configOption != null) {
            Arrays.asList(configOption.getValues()).forEach(value -> builder.suggest(ConfigOption.getValueAsText(value).getString()));
        }
        return builder.buildFuture();
    }

    private static <T> int setConfig(CommandContext<FabricClientCommandSource> context) {
        String value = StringArgumentType.getString(context, (String)"value");
        ConfigOption<?> option = ConfigArgumentType.getConfig(context, "config");
        if (option == null) {
            Notifier.error(class_2561.method_43471((String)"error.inventive_inventory.invalid_config_option").getString());
            return -1;
        }
        if (ConfigOption.getValueAsText(option.getValue()).getString().equals(value)) {
            Notifier.error(class_2561.method_43471((String)"error.inventive_inventory.already_set").getString() + value);
            return -1;
        }
        for (Object optionValue : option.getValues()) {
            if (!ConfigOption.getValueAsText(optionValue).getString().equals(value)) continue;
            option.setValue(value);
            Notifier.send(class_2561.method_43471((String)"notification.inventive_inventory.set").getString() + value, class_124.field_1060);
            return 1;
        }
        Notifier.error(class_2561.method_43471((String)"error.inventive_inventory.invalid_config_value").getString());
        return -1;
    }

    private static <T> int getInfo(CommandContext<FabricClientCommandSource> context) {
        ConfigOption<?> option = ConfigArgumentType.getConfig(context, "config");
        if (option == null) {
            Notifier.error(class_2561.method_43471((String)"error.inventive_inventory.invalid_config_option").getString());
            return -1;
        }
        Notifier.send(class_2561.method_43471((String)option.getTranslationKey()).getString() + ": " + ConfigOption.getValueAsText(option.getValue()).getString(), class_124.field_1078);
        return 1;
    }
}

