/*
 * Decompiled with CFR 0.152.
 */
package net.origins.inventive_inventory.commands.config.type;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.origins.inventive_inventory.commands.config.type.ConfigType;
import net.origins.inventive_inventory.config.ConfigManager;
import net.origins.inventive_inventory.config.options.ConfigOption;
import net.origins.inventive_inventory.util.StringFormatter;

public class ConfigArgumentType
implements ArgumentType<ConfigOption<?>> {
    private final ConfigType configType;

    private ConfigArgumentType(ConfigType configType) {
        this.configType = configType;
    }

    public static ConfigArgumentType of(ConfigType configType) {
        return new ConfigArgumentType(configType);
    }

    public static ConfigOption<?> getConfig(CommandContext<?> context, String name) {
        try {
            return (ConfigOption)context.getArgument(name, ConfigOption.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public ConfigOption<?> parse(StringReader reader) throws CommandSyntaxException {
        String str = StringFormatter.placeSpecialCharacters(reader.readString());
        for (Field field : ConfigManager.class.getDeclaredFields()) {
            if (!ConfigOption.class.isAssignableFrom(field.getType())) continue;
            try {
                String rawText;
                String finalText;
                ConfigOption option = (ConfigOption)field.get(null);
                if (this.configType != option.getConfigType() || !(finalText = StringFormatter.convertToCamelCase(rawText = class_2561.method_43471((String)option.getTranslationKey()).getString())).equals(str)) continue;
                return option;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (Field field : ConfigManager.class.getDeclaredFields()) {
            if (!ConfigOption.class.isAssignableFrom(field.getType())) continue;
            try {
                ConfigOption option = (ConfigOption)field.get(null);
                if (this.configType != option.getConfigType()) continue;
                String rawSuggest = class_2561.method_43471((String)option.getTranslationKey()).getString();
                String finalSuggest = StringFormatter.convertToCamelCase(StringFormatter.replaceSpecialCharacters(rawSuggest));
                builder.suggest(finalSuggest);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return builder.buildFuture();
    }
}

