/*
 * Decompiled with CFR 0.152.
 */
package net.origins.inventive_inventory.commands.profiles;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_7157;
import net.origins.inventive_inventory.features.profiles.ProfileHandler;
import net.origins.inventive_inventory.util.Notifier;

public class ProfilesCreateCommand {
    private static final String ERROR_TRANSLATION_KEY = "error.inventive_inventory.";

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 ignored) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"inventive-profiles").then(ClientCommandManager.literal((String)"create").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ProfilesCreateCommand::create)).then(ClientCommandManager.argument((String)"keybinding", (ArgumentType)StringArgumentType.word()).suggests(ProfilesCreateCommand::getKeyBinds).executes(ProfilesCreateCommand::createWithKeyBinding)))));
    }

    private static int create(CommandContext<FabricClientCommandSource> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        if (!name.isEmpty() && ProfileHandler.isNoProfile(name)) {
            ProfileHandler.create(name, "");
            return 1;
        }
        Notifier.error(class_2561.method_43471((String)"error.inventive_inventory.exclusive_name").getString());
        return -1;
    }

    private static int createWithKeyBinding(CommandContext<FabricClientCommandSource> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        String keyBinding = StringArgumentType.getString(context, (String)"keybinding");
        if (!name.isEmpty() && ProfileHandler.isNoProfile(name)) {
            for (class_304 key : ProfileHandler.getAvailableProfileKeys()) {
                if (!key.method_16007().getString().equals(keyBinding)) continue;
                ProfileHandler.create(name, key.method_1431());
                return 1;
            }
            Notifier.error(class_2561.method_43471((String)"error.inventive_inventory.key").getString());
            return -1;
        }
        Notifier.error(class_2561.method_43471((String)"error.inventive_inventory.name").getString());
        return -1;
    }

    private static CompletableFuture<Suggestions> getKeyBinds(CommandContext<FabricClientCommandSource> ignoredContext, SuggestionsBuilder builder) {
        ProfileHandler.getAvailableProfileKeys().forEach(keyBinding -> builder.suggest(keyBinding.method_16007().getString()));
        return builder.buildFuture();
    }
}

