/*
 * Decompiled with CFR 0.152.
 */
package net.origins.inventive_inventory.commands.profiles;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.origins.inventive_inventory.features.profiles.Profile;
import net.origins.inventive_inventory.features.profiles.ProfileHandler;
import net.origins.inventive_inventory.util.Notifier;

public class ProfilesDeleteCommand {
    private static final String ERROR_TRANSLATION_KEY = "error.inventive_inventory.";

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 ignored) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"inventive-profiles").then(ClientCommandManager.literal((String)"delete").then(ClientCommandManager.argument((String)"profile", (ArgumentType)StringArgumentType.greedyString()).suggests(ProfilesDeleteCommand::getProfiles).executes(ProfilesDeleteCommand::delete))));
    }

    private static int delete(CommandContext<FabricClientCommandSource> context) {
        String profileArg = StringArgumentType.getString(context, (String)"profile");
        for (Profile profile : ProfileHandler.getProfiles()) {
            if (profileArg.isEmpty() || !profile.getName().equals(profileArg)) continue;
            ProfileHandler.delete(profile);
            return 1;
        }
        Notifier.error(class_2561.method_43471((String)"error.inventive_inventory.does_not_exist").getString());
        return -1;
    }

    private static CompletableFuture<Suggestions> getProfiles(CommandContext<FabricClientCommandSource> ignoredContext, SuggestionsBuilder builder) {
        ProfileHandler.getProfiles().forEach(profile -> {
            if (!profile.getName().isEmpty()) {
                builder.suggest(profile.getName());
            }
        });
        return builder.buildFuture();
    }
}

