/*
 * Decompiled with CFR 0.152.
 */
package net.origins.inventive_inventory.events;

import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.origins.inventive_inventory.config.ConfigManager;
import net.origins.inventive_inventory.config.enums.Status;
import net.origins.inventive_inventory.config.enums.automatic_refilling.ToolReplacementBehaviour;
import net.origins.inventive_inventory.context.ContextManager;
import net.origins.inventive_inventory.context.Contexts;
import net.origins.inventive_inventory.features.automatic_refilling.AutomaticRefillingHandler;
import net.origins.inventive_inventory.features.locked_slots.LockedSlotsHandler;
import net.origins.inventive_inventory.features.profiles.Profile;
import net.origins.inventive_inventory.features.profiles.ProfileHandler;
import net.origins.inventive_inventory.features.profiles.gui.ProfilesScreen;
import net.origins.inventive_inventory.keys.KeyRegistry;
import net.origins.inventive_inventory.keys.handler.AdvancedOperationHandler;
import net.origins.inventive_inventory.util.InteractionHandler;

public class TickEvents {
    public static void register() {
        ClientTickEvents.START_CLIENT_TICK.register(TickEvents::checkKeys);
        ClientTickEvents.START_CLIENT_TICK.register(TickEvents::captureMainHand);
        ClientTickEvents.START_CLIENT_TICK.register(TickEvents::captureOffHand);
        ClientTickEvents.START_CLIENT_TICK.register(TickEvents::adjustInventory);
        ClientTickEvents.END_CLIENT_TICK.register(TickEvents::automaticRefilling);
        ClientTickEvents.END_CLIENT_TICK.register(TickEvents::loadProfile);
        ClientTickEvents.END_CLIENT_TICK.register(TickEvents::captureInventories);
    }

    private static void checkKeys(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) {
            return;
        }
        if (client.field_1755 == null) {
            AdvancedOperationHandler.setPressed(KeyRegistry.advancedOperationKey.method_1434());
        }
        if (AutomaticRefillingHandler.SELECTED_SLOT != InteractionHandler.getSelectedSlot()) {
            AutomaticRefillingHandler.reset();
        }
        if (KeyRegistry.openProfilesScreenKey.method_1434() && ConfigManager.PROFILES.is(Status.ENABLED)) {
            client.method_1507((class_437)new ProfilesScreen());
        }
    }

    private static void captureMainHand(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) {
            return;
        }
        if (client.field_1755 == null) {
            AutomaticRefillingHandler.runMainHand();
            if (client.field_1690.field_1904.method_1434() || client.field_1690.field_1869.method_1434() || client.field_1690.field_1886.method_1434()) {
                if (!ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.KEEP_TOOL) || !AutomaticRefillingHandler.TOOL_CLASSES.contains(InteractionHandler.getMainHandStack().method_7909().getClass()) || InteractionHandler.getMainHandStack().method_7936() - InteractionHandler.getMainHandStack().method_7919() != 1) {
                    AutomaticRefillingHandler.setMainHandStack(InteractionHandler.getMainHandStack());
                }
            } else {
                AutomaticRefillingHandler.reset();
            }
        } else {
            AutomaticRefillingHandler.reset();
        }
    }

    private static void captureOffHand(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) {
            return;
        }
        if (client.field_1755 == null) {
            if (AutomaticRefillingHandler.RUN_OFFHAND) {
                AutomaticRefillingHandler.runOffHand();
            } else {
                AutomaticRefillingHandler.RUN_OFFHAND = true;
            }
            if (!(!client.field_1690.field_1904.method_1434() || ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.KEEP_TOOL) && AutomaticRefillingHandler.TOOL_CLASSES.contains(InteractionHandler.getOffHandStack().method_7909().getClass()) && InteractionHandler.getOffHandStack().method_7936() - InteractionHandler.getOffHandStack().method_7919() == 1)) {
                AutomaticRefillingHandler.setOffHandStack(InteractionHandler.getOffHandStack());
            }
        } else {
            AutomaticRefillingHandler.reset();
        }
    }

    private static void adjustInventory(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) {
            return;
        }
        LockedSlotsHandler.adjustInventory();
    }

    private static void automaticRefilling(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) {
            return;
        }
        if (client.field_1755 == null && (client.field_1690.field_1904.method_1434() || client.field_1690.field_1869.method_1434() || client.field_1690.field_1886.method_1434())) {
            if (ConfigManager.AUTOMATIC_REFILLING_MODE.getValue().isValid() && ContextManager.isInit()) {
                ContextManager.setContext(Contexts.AUTOMATIC_REFILLING);
                AutomaticRefillingHandler.runMainHand();
                if (AutomaticRefillingHandler.RUN_OFFHAND) {
                    AutomaticRefillingHandler.runOffHand();
                }
                ContextManager.setContext(Contexts.INIT);
            } else {
                AutomaticRefillingHandler.reset();
            }
        }
    }

    private static void loadProfile(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) {
            return;
        }
        for (class_304 profileKey : KeyRegistry.profileKeys) {
            boolean validMode;
            if (!profileKey.method_1434()) continue;
            boolean bl = validMode = ConfigManager.FAST_LOAD.is(true) || ConfigManager.FAST_LOAD.is(false) && KeyRegistry.loadProfileKey.method_1434();
            if (!validMode || !ContextManager.isInit()) continue;
            ContextManager.setContext(Contexts.PROFILES);
            List<Profile> profiles = ProfileHandler.getProfiles();
            profiles.forEach(profile -> {
                if (profileKey.method_1431().equals(profile.getKey())) {
                    ProfileHandler.load(profile);
                }
            });
            ContextManager.setContext(Contexts.INIT);
        }
    }

    private static void captureInventories(class_310 client) {
        if (client.field_1724 != null) {
            LockedSlotsHandler.setSavedInventory();
            LockedSlotsHandler.setSavedHandlerInventory();
        }
    }
}

