/*
 * Decompiled with CFR 0.152.
 */
package net.origins.inventive_inventory.features.automatic_refilling;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.origins.inventive_inventory.config.ConfigManager;
import net.origins.inventive_inventory.config.enums.Status;
import net.origins.inventive_inventory.config.enums.automatic_refilling.ToolReplacementBehaviour;
import net.origins.inventive_inventory.config.enums.automatic_refilling.ToolReplacementPriority;
import net.origins.inventive_inventory.util.InteractionHandler;
import net.origins.inventive_inventory.util.slots.PlayerSlots;
import net.origins.inventive_inventory.util.slots.SlotRange;
import net.origins.inventive_inventory.util.slots.SlotTypes;

public class AutomaticRefillingHandler {
    public static final List<Class<? extends class_1792>> TOOL_CLASSES = List.of(class_1829.class, class_1810.class, class_1743.class, class_1821.class, class_1794.class, class_1753.class, class_1764.class, class_1835.class);
    private static final List<class_1792> EMPTIES = List.of(class_1802.field_8550, class_1802.field_8469, class_1802.field_8428);
    public static int SELECTED_SLOT;
    public static boolean RUN_OFFHAND;
    private static class_1799 offHandStack;
    private static class_1799 mainHandStack;

    public static void setOffHandStack(class_1799 itemStack) {
        offHandStack = itemStack.method_7972();
    }

    public static void setMainHandStack(class_1799 itemStack) {
        mainHandStack = itemStack.method_7972();
    }

    public static void runMainHand() {
        boolean handFullAndToolDurabilityOver1;
        SELECTED_SLOT = InteractionHandler.getSelectedSlot();
        boolean isAutomaticRefillingDisabled = ConfigManager.AUTOMATIC_REFILLING.is(Status.DISABLED);
        boolean capturedStackIsEmpty = class_1799.method_7984((class_1799)mainHandStack, (class_1799)class_1799.field_8037);
        class_1799 currentStack = InteractionHandler.getMainHandStack();
        boolean handFullAndNoTool = class_1799.method_7984((class_1799)mainHandStack, (class_1799)currentStack) && !TOOL_CLASSES.contains(currentStack.method_7909().getClass());
        boolean bl = handFullAndToolDurabilityOver1 = class_1799.method_7984((class_1799)mainHandStack, (class_1799)currentStack) && TOOL_CLASSES.contains(currentStack.method_7909().getClass()) && currentStack.method_7936() - currentStack.method_7919() > 1;
        if (isAutomaticRefillingDisabled || capturedStackIsEmpty || handFullAndNoTool || handFullAndToolDurabilityOver1) {
            return;
        }
        if (ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.BREAK_TOOL) && TOOL_CLASSES.contains(currentStack.method_7909().getClass()) && currentStack.method_7936() - currentStack.method_7919() == 1) {
            return;
        }
        List<Integer> sameItemSlots = AutomaticRefillingHandler.getSameItemSlots(mainHandStack);
        int emptiesSlot = InteractionHandler.getSelectedSlot();
        if (!sameItemSlots.isEmpty()) {
            if (SlotRange.slotIn(SlotTypes.HOTBAR, sameItemSlots.get(0))) {
                InteractionHandler.setSelectedSlot(sameItemSlots.get(0) - 36);
            } else {
                InteractionHandler.swapStacks(sameItemSlots.get(0), InteractionHandler.getSelectedSlot());
                emptiesSlot = sameItemSlots.get(0);
            }
            RUN_OFFHAND = false;
            offHandStack = class_1799.field_8037;
        }
        mainHandStack = class_1799.field_8037;
        if (EMPTIES.contains(InteractionHandler.getStackFromSlot(emptiesSlot).method_7909())) {
            AutomaticRefillingHandler.mergeEmpties(emptiesSlot);
        }
    }

    public static void runOffHand() {
        boolean handFullAndToolDurabilityOver1;
        boolean isAutomaticRefillingDisabled = ConfigManager.AUTOMATIC_REFILLING.is(Status.DISABLED);
        boolean capturedStackIsEmpty = class_1799.method_7984((class_1799)offHandStack, (class_1799)class_1799.field_8037);
        class_1799 currentStack = InteractionHandler.getOffHandStack();
        boolean handFullAndNoTool = class_1799.method_7984((class_1799)offHandStack, (class_1799)currentStack) && !TOOL_CLASSES.contains(currentStack.method_7909().getClass());
        boolean bl = handFullAndToolDurabilityOver1 = class_1799.method_7984((class_1799)offHandStack, (class_1799)currentStack) && TOOL_CLASSES.contains(currentStack.method_7909().getClass()) && currentStack.method_7936() - currentStack.method_7919() > 1;
        if (isAutomaticRefillingDisabled || capturedStackIsEmpty || handFullAndNoTool || handFullAndToolDurabilityOver1) {
            return;
        }
        if (ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.BREAK_TOOL) && TOOL_CLASSES.contains(currentStack.method_7909().getClass()) && currentStack.method_7936() - currentStack.method_7919() == 1) {
            return;
        }
        SELECTED_SLOT = InteractionHandler.getSelectedSlot();
        List<Integer> sameItemSlots = AutomaticRefillingHandler.getSameItemSlots(offHandStack);
        int emptiesSlot = 45;
        if (!sameItemSlots.isEmpty()) {
            InteractionHandler.swapStacks(sameItemSlots.get(0), 45);
            emptiesSlot = sameItemSlots.get(0);
        }
        offHandStack = class_1799.field_8037;
        if (EMPTIES.contains(InteractionHandler.getStackFromSlot(emptiesSlot).method_7909())) {
            AutomaticRefillingHandler.mergeEmpties(emptiesSlot);
        }
    }

    public static void reset() {
        AutomaticRefillingHandler.setMainHandStack(class_1799.field_8037);
        AutomaticRefillingHandler.setOffHandStack(class_1799.field_8037);
        RUN_OFFHAND = true;
        SELECTED_SLOT = -1;
    }

    private static List<Integer> getSameItemSlots(class_1799 handStack) {
        SlotRange slotRange = PlayerSlots.get().append(SlotTypes.HOTBAR).exclude(InteractionHandler.getSelectedSlot());
        slotRange = ConfigManager.AUTOMATIC_REFILLING_IGNORE_LOCKED_SLOTS.is(true) ? slotRange.exclude(SlotTypes.LOCKED_SLOT) : slotRange;
        Stream<Integer> sameItemSlotsStream = slotRange.stream().filter(slot -> {
            class_1799 itemStack = InteractionHandler.getStackFromSlot(slot);
            boolean isEqualAndNoTool = class_1799.method_7984((class_1799)handStack, (class_1799)itemStack) && class_2512.method_10687((class_2520)handStack.method_7969(), (class_2520)itemStack.method_7969(), (boolean)true) && !TOOL_CLASSES.contains(itemStack.method_7909().getClass());
            boolean isSameToolType = itemStack.method_7909().getClass().equals(handStack.method_7909().getClass()) && TOOL_CLASSES.contains(itemStack.method_7909().getClass());
            return isEqualAndNoTool || isSameToolType && ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.KEEP_TOOL) && itemStack.method_7936() - itemStack.method_7919() > 1 || isSameToolType && ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.BREAK_TOOL);
        });
        if (TOOL_CLASSES.contains(handStack.method_7909().getClass())) {
            if (ConfigManager.TOOL_REPLACEMENT_PRIORITY.is(ToolReplacementPriority.MATERIAL)) {
                sameItemSlotsStream = sameItemSlotsStream.sorted(Comparator.comparing(slot -> InteractionHandler.getStackFromSlot(slot).method_7936(), Comparator.reverseOrder()));
            } else if (ConfigManager.TOOL_REPLACEMENT_PRIORITY.is(ToolReplacementPriority.REMAINING_HEALTH)) {
                sameItemSlotsStream = sameItemSlotsStream.sorted(Comparator.comparing(slot -> InteractionHandler.getStackFromSlot(slot).method_7936() - InteractionHandler.getStackFromSlot(slot).method_7919()));
            }
        } else {
            sameItemSlotsStream = sameItemSlotsStream.sorted(Comparator.comparing(slot -> InteractionHandler.getStackFromSlot(slot).method_7947()));
        }
        ArrayList<Integer> sameItemSlots = new ArrayList<Integer>(sameItemSlotsStream.toList());
        SlotRange hotbarSlotRange = SlotRange.of(sameItemSlots).exclude(SlotTypes.INVENTORY);
        SlotRange inventorySlotRange = SlotRange.of(sameItemSlots).exclude(SlotTypes.HOTBAR);
        sameItemSlots.removeAll(!hotbarSlotRange.isEmpty() ? inventorySlotRange : hotbarSlotRange);
        return sameItemSlots;
    }

    private static void mergeEmpties(int itemSlot) {
        SlotRange slotRange = PlayerSlots.get().append(SlotTypes.HOTBAR).exclude(itemSlot);
        slotRange = ConfigManager.AUTOMATIC_REFILLING_IGNORE_LOCKED_SLOTS.is(true) ? slotRange.exclude(SlotTypes.LOCKED_SLOT) : slotRange;
        List<Integer> sameItemSlots = slotRange.stream().filter(slot -> InteractionHandler.getStackFromSlot(slot).method_7909().equals(InteractionHandler.getStackFromSlot(itemSlot).method_7909())).filter(slot -> InteractionHandler.getStackFromSlot(slot).method_7947() < InteractionHandler.getStackFromSlot(slot).method_7914()).sorted(Comparator.comparing(slot -> InteractionHandler.getStackFromSlot(slot).method_7947(), Comparator.reverseOrder())).toList();
        if (!sameItemSlots.isEmpty()) {
            InteractionHandler.leftClickStack(itemSlot);
            InteractionHandler.leftClickStack(sameItemSlots.get(0));
        }
    }

    static {
        RUN_OFFHAND = true;
        offHandStack = class_1799.field_8037;
        mainHandStack = class_1799.field_8037;
    }
}

