/*
 * Decompiled with CFR 0.152.
 */
package net.origins.inventive_inventory.features.profiles;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1799;
import net.origins.inventive_inventory.features.profiles.SavedSlot;
import net.origins.inventive_inventory.util.Converter;
import net.origins.inventive_inventory.util.InteractionHandler;

public class Profile {
    private final int id;
    private final class_1799 displayStack;
    private final List<SavedSlot> savedSlots;
    private final String name;
    private final String key;

    public Profile(int id, String name, String key, List<SavedSlot> savedSlots) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.savedSlots = savedSlots;
        this.displayStack = InteractionHandler.getAnyHandStack();
    }

    public Profile(int id, String name, String key, JsonObject displayStack, JsonArray savedSlots) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.displayStack = Converter.jsonToItemStack(displayStack);
        this.savedSlots = Converter.jsonToSavedSlots(savedSlots);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public List<SavedSlot> getSavedSlots() {
        return this.savedSlots;
    }

    public class_1799 getDisplayStack() {
        return this.displayStack;
    }

    public JsonObject getAsJsonObject() {
        JsonObject jsonProfile = new JsonObject();
        jsonProfile.addProperty("id", (Number)this.id);
        jsonProfile.addProperty("name", this.name);
        jsonProfile.addProperty("key", this.key);
        jsonProfile.add("display_stack", (JsonElement)Converter.itemStackToJson(this.displayStack));
        JsonArray jsonArray = new JsonArray();
        for (SavedSlot savedSlot : this.savedSlots) {
            JsonObject savedSlotMap = new JsonObject();
            savedSlotMap.addProperty("slot", (Number)savedSlot.slot());
            savedSlotMap.add("stack", (JsonElement)Converter.itemStackToJson(savedSlot.stack()));
            jsonArray.add((JsonElement)savedSlotMap);
        }
        jsonProfile.add("saved_slots", (JsonElement)jsonArray);
        return jsonProfile;
    }
}

