/*
 * Decompiled with CFR 0.152.
 */
package net.origins.inventive_inventory.features.profiles;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.origins.inventive_inventory.InventiveInventory;
import net.origins.inventive_inventory.config.ConfigManager;
import net.origins.inventive_inventory.config.enums.Status;
import net.origins.inventive_inventory.features.profiles.Profile;
import net.origins.inventive_inventory.features.profiles.SavedSlot;
import net.origins.inventive_inventory.keys.KeyRegistry;
import net.origins.inventive_inventory.util.ComponentsHelper;
import net.origins.inventive_inventory.util.FileHandler;
import net.origins.inventive_inventory.util.InteractionHandler;
import net.origins.inventive_inventory.util.Notifier;
import net.origins.inventive_inventory.util.slots.PlayerSlots;
import net.origins.inventive_inventory.util.slots.SlotRange;
import net.origins.inventive_inventory.util.slots.SlotTypes;

public class ProfileHandler {
    private static final String ERROR_TRANSLATION_KEY = "error.inventive_inventory.";
    private static final String NOTIFICATION_TRANSLATION_KEY = "notification.inventive_inventory.";
    public static final int MAX_PROFILES = 5;
    private static final String PROFILES_FILE = "profiles.json";
    public static final Path PROFILES_PATH = ConfigManager.CONFIG_PATH.resolve("profiles.json");

    public static void create(String name, String key) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES.is(Status.DISABLED)) {
            return;
        }
        JsonArray profilesJson = ProfileHandler.getJsonProfiles();
        Profile profile = new Profile(profilesJson.size(), name, key, ProfileHandler.createSavedSlots());
        if (profilesJson.size() < 5) {
            profilesJson.add((JsonElement)profile.getAsJsonObject());
            ProfileHandler.save(profilesJson);
            Notifier.send(class_2561.method_43471((String)"notification.inventive_inventory.profile_created").getString(), class_124.field_1060);
            return;
        }
        Notifier.error(class_2561.method_43471((String)"error.inventive_inventory.max_amount").getString());
    }

    public static void load(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES.is(Status.DISABLED)) {
            return;
        }
        SlotRange slotRange = PlayerSlots.get(SlotTypes.INVENTORY, SlotTypes.HOTBAR, SlotTypes.OFFHAND);
        slotRange = ConfigManager.PROFILES_IGNORE_LOCKED_SLOTS.is(true) ? slotRange.exclude(SlotTypes.LOCKED_SLOT) : slotRange;
        block0: for (SavedSlot savedSlot : profile.getSavedSlots()) {
            Iterator iterator = slotRange.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                class_1799 slotStack = InteractionHandler.getStackFromSlot(slot);
                if (!class_1799.method_7984((class_1799)slotStack, (class_1799)savedSlot.stack()) || !ComponentsHelper.areCustomNamesEqual(slotStack, savedSlot.stack()) || !ComponentsHelper.areEnchantmentsEqual(slotStack, savedSlot.stack()) || !ComponentsHelper.arePotionsEqual(slotStack, savedSlot.stack())) continue;
                InteractionHandler.swapStacks(slot, savedSlot.slot());
                continue block0;
            }
        }
        Notifier.send(class_2561.method_43471((String)"notification.inventive_inventory.profile_loaded").getString(), class_124.field_1078);
    }

    public static void overwrite(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES.is(Status.DISABLED)) {
            return;
        }
        JsonArray profilesJson = ProfileHandler.getJsonProfiles();
        Profile newProfile = new Profile(profile.getId(), profile.getName(), profile.getKey(), ProfileHandler.createSavedSlots());
        if (profilesJson.isEmpty()) {
            profilesJson.add((JsonElement)newProfile.getAsJsonObject());
        } else {
            profilesJson.set(profile.getId(), (JsonElement)newProfile.getAsJsonObject());
        }
        ProfileHandler.save(profilesJson);
        Notifier.send(class_2561.method_43471((String)"notification.inventive_inventory.profile_overwritten").getString(), class_124.field_1065);
    }

    public static void delete(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES.is(Status.DISABLED)) {
            return;
        }
        JsonArray profilesJson = ProfileHandler.getJsonProfiles();
        if (!profilesJson.isEmpty()) {
            profilesJson.remove(profile.getId());
        }
        for (int i = 0; i < profilesJson.size(); ++i) {
            JsonObject jsonProfile = profilesJson.get(i).getAsJsonObject();
            jsonProfile.addProperty("id", (Number)i);
            profilesJson.set(i, (JsonElement)jsonProfile);
        }
        ProfileHandler.save(profilesJson);
        Notifier.send(class_2561.method_43471((String)"notification.inventive_inventory.profile_deleted").getString(), class_124.field_1061);
    }

    public static List<Profile> getProfiles() {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (JsonElement profileElement : ProfileHandler.getJsonProfiles()) {
            JsonObject jsonProfile = profileElement.getAsJsonObject();
            if (profiles.size() >= 5) continue;
            profiles.add(new Profile(jsonProfile.get("id").getAsInt(), jsonProfile.get("name").getAsString(), jsonProfile.get("key").getAsString(), jsonProfile.getAsJsonObject("display_stack"), jsonProfile.getAsJsonArray("saved_slots")));
        }
        return profiles;
    }

    public static boolean isNoProfile(String name) {
        for (Profile profile : ProfileHandler.getProfiles()) {
            if (!profile.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public static String getAvailableProfileKey() {
        List<class_304> availableProfileKeys = ProfileHandler.getAvailableProfileKeys();
        if (availableProfileKeys.isEmpty()) {
            return "";
        }
        return availableProfileKeys.get(0).method_1431();
    }

    public static List<class_304> getAvailableProfileKeys() {
        ArrayList<class_304> availableProfileKeys = new ArrayList<class_304>(Arrays.asList(KeyRegistry.profileKeys));
        for (Profile profile : ProfileHandler.getProfiles()) {
            for (class_304 profileKey : KeyRegistry.profileKeys) {
                if (!profileKey.method_1431().equals(profile.getKey())) continue;
                availableProfileKeys.remove(profileKey);
            }
        }
        return availableProfileKeys;
    }

    private static void save(JsonArray profiles) {
        JsonObject jsonObject = FileHandler.get(PROFILES_PATH).isJsonObject() ? FileHandler.get(PROFILES_PATH).getAsJsonObject() : new JsonObject();
        jsonObject.remove(InventiveInventory.getWorldName());
        jsonObject.add(InventiveInventory.getWorldName(), (JsonElement)profiles);
        FileHandler.write(PROFILES_PATH, (JsonElement)jsonObject);
    }

    private static List<SavedSlot> createSavedSlots() {
        class_1703 screenHandler = InventiveInventory.getScreenHandler();
        ArrayList<SavedSlot> savedSlots = new ArrayList<SavedSlot>();
        Iterator iterator = PlayerSlots.get(SlotTypes.HOTBAR, SlotTypes.OFFHAND).iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            class_1799 stack = screenHandler.method_7611(slot).method_7677();
            if (stack.method_7960()) continue;
            savedSlots.add(new SavedSlot(slot, stack));
        }
        return savedSlots;
    }

    private static JsonArray getJsonProfiles() {
        return FileHandler.get(PROFILES_PATH).isJsonObject() && FileHandler.get(PROFILES_PATH).getAsJsonObject().has(InventiveInventory.getWorldName()) ? FileHandler.get(PROFILES_PATH).getAsJsonObject().getAsJsonArray(InventiveInventory.getWorldName()) : new JsonArray();
    }
}

