/*
 * Decompiled with CFR 0.152.
 */
package net.origins.inventive_inventory.util.tooltips;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1890;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_304;
import net.origins.inventive_inventory.features.profiles.Profile;
import net.origins.inventive_inventory.keys.KeyRegistry;
import net.origins.inventive_inventory.util.tooltips.TooltipType;

public class TooltipBuilder {
    private static final String TOOLTIP_TRANSLATION_KEY = "tooltip.inventive_inventory.";
    private static final String DEFAULT_TRANSLATION_KEY = "default.inventive_inventory.";

    public static List<class_2561> of(TooltipType type, Profile profile) {
        if (type == TooltipType.NAME) {
            return TooltipBuilder.buildName(profile);
        }
        if (type == TooltipType.ITEM) {
            return TooltipBuilder.buildItem(profile);
        }
        if (type == TooltipType.UNKNOWN) {
            return TooltipBuilder.buildUnknown(profile);
        }
        if (type == TooltipType.PLUS) {
            return TooltipBuilder.buildPlus();
        }
        return new ArrayList<class_2561>();
    }

    private static List<class_2561> buildName(Profile profile) {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        TooltipBuilder.addTitle(class_2561.method_30163((String)profile.getName()), class_124.field_1065, textList);
        TooltipBuilder.addKey(profile, textList);
        return textList;
    }

    private static List<class_2561> buildItem(Profile profile) {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        TooltipBuilder.addTitle(class_2561.method_30163((String)profile.getDisplayStack().method_7964().getString()), class_124.field_1075, textList);
        if (profile.getDisplayStack().method_7942()) {
            Map enchantments = class_1890.method_22445((class_2499)profile.getDisplayStack().method_7921());
            enchantments.forEach((enchantment, integer) -> textList.add(enchantment.method_8179(integer.intValue())));
            textList.add((class_2561)class_2561.method_43473());
        }
        TooltipBuilder.addKey(profile, textList);
        return textList;
    }

    private static List<class_2561> buildUnknown(Profile profile) {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        TooltipBuilder.addTitle((class_2561)class_2561.method_43471((String)"default.inventive_inventory.unnamed"), class_124.field_1080, textList);
        TooltipBuilder.addKey(profile, textList);
        return textList;
    }

    private static List<class_2561> buildPlus() {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        textList.add((class_2561)class_2561.method_43471((String)"tooltip.inventive_inventory.plus.1"));
        textList.add((class_2561)class_2561.method_43471((String)"tooltip.inventive_inventory.plus.2"));
        return textList;
    }

    private static void addTitle(class_2561 title, class_124 formatting, List<class_2561> textList) {
        textList.add((class_2561)title.method_27661().method_10862(class_2583.field_24360.method_10977(formatting)));
    }

    private static void addKey(Profile profile, List<class_2561> textList) {
        class_304 keyBinding;
        if (profile.getKey() != null && (keyBinding = KeyRegistry.getByTranslationKey(profile.getKey())) != null) {
            textList.add(class_2561.method_30163((String)(class_2561.method_43471((String)"default.inventive_inventory.key").getString() + ": " + keyBinding.method_16007().getString())));
        }
    }
}

