/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelbear<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"modelbear"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart leg0;
    public final ModelPart leg1;
    public final ModelPart leg2;
    public final ModelPart leg3;

    public Modelbear(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.leg0 = root.getChild("leg0");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -17.0f, -7.0f, 14.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(34, 29).addBox(-4.0f, -25.0f, -7.0f, 12.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 21).addBox(-4.0f, -7.0f, -7.0f, 12.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(55, 0).addBox(1.0f, 1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)9.0f, (float)12.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(43, 14).addBox(-3.5f, -3.0f, -6.0f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(39, 0).addBox(-2.5f, 0.0f, -9.0f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).mirror().addBox(-4.5f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).addBox(2.5f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.0f, (float)-13.0f));
        PartDefinition leg0 = partdefinition.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(71, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)14.0f, (float)6.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(71, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)14.0f, (float)6.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(71, 18).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)14.0f, (float)-8.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(71, 18).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.5f, (float)14.0f, (float)-8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg0.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leg0.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

