/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureAttachedFaceBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.LightswitchBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.data.DropWithName;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LightswitchBlock
extends FurnitureAttachedFaceBlock
implements EntityBlock,
BlockTagSupplier,
DropWithName {
    private static final MapCodec<LightswitchBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)MetalType.CODEC.fieldOf("metal_type").forGetter(block -> block.type), (App)LightswitchBlock.propertiesCodec()).apply((Applicative)builder, LightswitchBlock::new));
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected final MetalType type;

    public LightswitchBlock(MetalType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public MetalType getMetalType() {
        return this.type;
    }

    protected MapCodec<LightswitchBlock> codec() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape wallShape = Block.box((double)14.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
        VoxelShape ceilingShape = Block.box((double)4.0, (double)14.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);
        VoxelShape floorShape = Block.box((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)2.0, (double)11.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            Direction facing = (Direction)state.getValue((Property)FACING);
            AttachFace face = (AttachFace)state.getValue((Property)FACE);
            return switch (face) {
                default -> throw new MatchException(null, null);
                case AttachFace.FLOOR -> VoxelShapeHelper.rotateHorizontally(floorShape, facing.getOpposite());
                case AttachFace.WALL -> VoxelShapeHelper.rotateHorizontally(wallShape, facing.getOpposite());
                case AttachFace.CEILING -> VoxelShapeHelper.rotateHorizontally(ceilingShape, facing.getOpposite());
            };
        })));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        boolean enabled = (Boolean)state.getValue((Property)ENABLED) == false;
        level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(enabled)), 3);
        Vec3 sound = this.getPositionForSound(state, pos);
        level.playSound(null, sound.x, sound.y, sound.z, (SoundEvent)ModSounds.BLOCK_LIGHTSWITCH_FLICK.get(), SoundSource.BLOCKS, 0.7f, enabled ? 1.0f : 0.8f);
        return InteractionResult.SUCCESS;
    }

    private Vec3 getPositionForSound(BlockState state, BlockPos pos) {
        Vec3 center = pos.getCenter();
        AttachFace face = (AttachFace)state.getValue((Property)FACE);
        return switch (face) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> center.subtract(0.0, 0.5, 0.0);
            case AttachFace.CEILING -> center.add(0.0, 0.5, 0.0);
            case AttachFace.WALL -> {
                Direction dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
                yield center.add((double)dir.getStepX() * 0.5, 0.0, (double)dir.getStepZ() * 0.5);
            }
        };
    }

    @Override
    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        return (Boolean)state.getValue((Property)ENABLED) != false ? 1 : 0;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ENABLED});
        builder.add(new Property[]{POWERED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LightswitchBlockEntity(pos, state);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_PICKAXE);
    }
}

