/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.electricity;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.resource.ResourceHandle;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.client.electricity.CachedElectricityNodes;
import com.mrcrayfish.furniture.refurbished.client.electricity.WrenchHandler;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.ConnectionRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.ElectricityRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.LinkingConnectionRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.NodeRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.PowerableAreaRenderState;
import com.mrcrayfish.furniture.refurbished.core.ModRenderPipelines;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class ElectricityRenderer
implements ResourceManagerReloadListener {
    public static final String PASS_NAME = "refurbished_furniture_electricity";
    public static final ResourceLocation ID = Utils.resource("electricity_renderer");
    private static final ResourceLocation POWERABLE_AREA = Utils.resource("textures/misc/powerable_area.png");
    private static final ResourceLocation UNPOWERABLE_AREA = Utils.resource("textures/misc/unpowerable_area.png");
    private static ElectricityRenderer instance;
    private final SubmitStorage storage = new SubmitStorage();
    private final PoseStack poseStack = new PoseStack();
    private final ElectricityRenderState renderState = new ElectricityRenderState();
    @Nullable
    private Class<?> irisClass;
    private Method shaderPack;
    private Boolean shaderEnabled;
    private TextureTarget electricityTarget;
    private ResourceHandle<TextureTarget> handle;
    private boolean takenScreenshot;

    public static ElectricityRenderer get() {
        if (instance == null) {
            instance = new ElectricityRenderer();
        }
        return instance;
    }

    private ElectricityRenderer() {
        this.setupIrisSupport();
    }

    private void setupIrisSupport() {
        try {
            this.irisClass = Class.forName("net.irisshaders.iris.Iris");
            this.shaderPack = this.irisClass.getDeclaredMethod("getCurrentPack", new Class[0]);
            this.shaderPack.setAccessible(true);
            Constants.LOG.info("Iris detected! Will use modified rendering for electricity when shaders are enabled");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to locate Iris shader pack getter", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public boolean isIrisShadersEnabled() {
        if (this.irisClass != null && this.shaderPack != null && this.shaderEnabled == null) {
            try {
                Optional optional = (Optional)this.shaderPack.invoke(null, new Object[0]);
                this.shaderEnabled = optional.isPresent();
                return this.shaderEnabled;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke shader pack getter", e);
            }
        }
        return this.shaderEnabled != null && this.shaderEnabled != false;
    }

    public void onResourceManagerReload(ResourceManager manager) {
        if (this.electricityTarget != null) {
            this.electricityTarget.destroyBuffers();
        }
        Window window = Minecraft.getInstance().getWindow();
        this.electricityTarget = new TextureTarget("Refurbished Furniture Electricity Overlay", window.getWidth(), window.getHeight(), true);
    }

    public void resize(int width, int height) {
        if (this.electricityTarget != null) {
            this.electricityTarget.resize(width, height);
        }
    }

    public TextureTarget getTextureTarget() {
        return this.electricityTarget;
    }

    public ElectricityRenderState getRenderState() {
        return this.renderState;
    }

    public void extract(Camera camera) {
        this.renderState.reset();
        if (WrenchHandler.isHoldingWrench()) {
            WrenchHandler handler = WrenchHandler.get();
            handler.extractLinkingConnection(this.renderState);
            this.forEachVisibleElectricityNode(camera, node -> {
                boolean nodeCanBeSelected = handler.isTargetNode((IElectricityNode)node) && !handler.isCreatingLink() && !node.isNodeConnectionLimitReached();
                boolean nodeIsBeingLinked = handler.isSelectedNode((IElectricityNode)node);
                boolean nodeIsJoinable = handler.canLinkToNode((IElectricityNode)node) && handler.isTargetNode((IElectricityNode)node);
                boolean nodeHighlighted = nodeCanBeSelected || nodeIsBeingLinked || nodeIsJoinable;
                NodeRenderState nodeState = new NodeRenderState();
                nodeState.box = node.getNodeInteractBox().move(node.getNodePosition());
                nodeState.highlighted = nodeHighlighted;
                nodeState.highlightColour = handler.getLinkColour();
                this.renderState.nodes.add(nodeState);
                for (Connection connection : node.getNodeConnections()) {
                    BlockPos start = connection.getPosA();
                    BlockPos end = connection.getPosB();
                    boolean hovered = !handler.isCreatingLink() && connection.equals(handler.getTargetConnection());
                    int colour = connection.getColour(node.getNodeLevel());
                    this.renderState.connections.add(new ConnectionRenderState(start, end, hovered, colour));
                }
            });
        }
    }

    private void submitElectricityRenderState(ElectricityRenderState renderState, PoseStack stack) {
        renderState.nodes.forEach(box -> this.storage.submitNode(stack, (NodeRenderState)box));
        renderState.connections.forEach(connection -> this.storage.submitConnection(stack, (ConnectionRenderState)connection));
        if (renderState.link != null) {
            this.storage.submitLinkingConnection(stack, renderState.link);
        }
    }

    public void setupFramePass(FrameGraphBuilder builder, Vec3 camera) {
        this.shaderEnabled = null;
        ResourceHandle handle = builder.importExternal(PASS_NAME, (Object)this.electricityTarget);
        FramePass pass = builder.addPass(PASS_NAME);
        this.handle = pass.readsAndWrites(handle);
        pass.executes(() -> {
            GpuTexture colorTexture = this.electricityTarget.getColorTexture();
            GpuTexture depthTexture = this.electricityTarget.getDepthTexture();
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(colorTexture, 0, depthTexture, 1.0);
            PoseStack stack = new PoseStack();
            stack.translate(-camera.x, -camera.y, -camera.z);
            this.submitElectricityRenderState(this.renderState, stack);
            RenderType renderType = ClientServices.PLATFORM.getElectricityRenderType();
            MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
            VertexConsumer vertexConsumer = source.getBuffer(renderType);
            this.storage.linkingConnectionSubmits.forEach(submit -> this.renderLinkingConnection(submit.pose, vertexConsumer, submit.linkingConnectionRenderState));
            this.storage.nodeSubmits.forEach(submit -> submit.renderer.accept(submit.pose, vertexConsumer));
            this.storage.connectionSubmits.forEach(submit -> this.renderConnection(submit.pose, vertexConsumer, submit.connectionRenderState));
            source.endBatch(renderType);
            this.storage.clear();
        });
    }

    public void blitToScreen() {
        this.tryAndTakeDebugScreenshot();
        if (this.handle != null) {
            GpuTextureView mainTexture = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
            GpuTextureView electricityTexture = this.electricityTarget.getColorTextureView();
            if (electricityTexture != null && mainTexture != null) {
                try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Blit", mainTexture, OptionalInt.empty());){
                    pass.setPipeline(ModRenderPipelines.ELECTRICITY_BLIT);
                    RenderSystem.bindDefaultUniforms((RenderPass)pass);
                    pass.bindSampler("InSampler", electricityTexture);
                    pass.draw(0, 3);
                }
            }
        }
        this.handle = null;
    }

    private void renderConnection(PoseStack.Pose pose, VertexConsumer vertexConsumer, ConnectionRenderState state) {
        this.poseStack.pushPose();
        this.poseStack.last().set(pose);
        BlockPos start = state.a();
        this.poseStack.translate((float)start.getX(), (float)start.getY(), (float)start.getZ());
        this.poseStack.translate(0.5, 0.5, 0.5);
        Vec3 delta = Vec3.atLowerCornerOf((Vec3i)state.b().subtract((Vec3i)state.a()));
        double yaw = Math.atan2(-delta.z, delta.x) + Math.PI;
        double pitch = Math.atan2(delta.horizontalDistance(), delta.y) + 1.5707963705062866;
        this.poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)yaw));
        this.poseStack.mulPose((Quaternionfc)Axis.ZP.rotation((float)pitch));
        float offset = (float)(Math.sin((double)Util.getMillis() / 500.0) + 1.0) / 2.0f * 0.2f;
        AABB box = new AABB(0.0, -0.03125, -0.03125, delta.length(), 0.03125, 0.03125);
        ElectricityRenderer.drawColouredBox(this.poseStack.last(), vertexConsumer, box, state.colour(), 0.7f + offset);
        ElectricityRenderer.drawColouredBox(this.poseStack.last(), vertexConsumer, box.inflate(0.03125), state.colour(), 0.5f + offset);
        if (state.hovered()) {
            ElectricityRenderer.drawColouredBox(this.poseStack.last(), vertexConsumer, box.inflate(0.03125), -1, 0.8f);
        }
        this.poseStack.popPose();
    }

    private void renderLinkingConnection(PoseStack.Pose pose, VertexConsumer vertexConsumer, LinkingConnectionRenderState state) {
        this.poseStack.pushPose();
        this.poseStack.last().set(pose);
        Vec3 delta = state.end.subtract(state.start);
        double yaw = Math.atan2(-delta.z, delta.x) + Math.PI;
        double pitch = Math.atan2(delta.horizontalDistance(), delta.y) + 1.5707963705062866;
        this.poseStack.translate(state.start.x, state.start.y, state.start.z);
        this.poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)yaw));
        this.poseStack.mulPose((Quaternionfc)Axis.ZP.rotation((float)pitch));
        ElectricityRenderer.drawColouredBox(this.poseStack.last(), vertexConsumer, new AABB(0.0, -0.03125, -0.03125, delta.length(), 0.03125, 0.03125), state.colour, 0.8f);
        ElectricityRenderer.drawColouredBox(this.poseStack.last(), vertexConsumer, new AABB(0.0, -0.03125, -0.03125, delta.length(), 0.03125, 0.03125).inflate(0.03125), state.colour, 0.6f);
        this.poseStack.popPose();
    }

    public void renderPowerableArea(Vec3 camera) {
        block19: {
            PowerableAreaRenderState renderState = new PowerableAreaRenderState();
            WrenchHandler handler = WrenchHandler.get();
            handler.extractPowerableArea(renderState, camera);
            if (renderState.shape == null || renderState.alpha <= 0.0f) {
                return;
            }
            PoseStack stack = new PoseStack();
            stack.translate(-camera.x, -camera.y, -camera.z);
            boolean shaders = ElectricityRenderer.get().isIrisShadersEnabled();
            RenderPipeline pipeline = shaders ? RenderPipelines.WORLD_BORDER : ModRenderPipelines.POWERABLE_AREA;
            try (ByteBufferBuilder quadBuilder = new ByteBufferBuilder(pipeline.getVertexFormat().getVertexSize() * 4);){
                BufferBuilder vertexBuilder = new BufferBuilder(quadBuilder, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
                renderState.shape.toAabbs().forEach(box -> ElectricityRenderer.drawPowerableAreaBox(stack.last(), (VertexConsumer)vertexBuilder, box));
                try (MeshData data = vertexBuilder.build();){
                    if (data == null) break block19;
                    RenderTarget mainTarget = Minecraft.getInstance().getMainRenderTarget();
                    RenderTarget weatherTarget = Minecraft.getInstance().levelRenderer.getWeatherTarget();
                    GpuTextureView mainColor = mainTarget.getColorTextureView();
                    GpuTextureView mainDepth = mainTarget.getDepthTextureView();
                    if (weatherTarget != null) {
                        // empty if block
                    }
                    GpuBufferSlice slice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 0.6f * renderState.alpha), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                    RenderSystem.AutoStorageIndexBuffer autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)pipeline.getVertexFormatMode());
                    VertexFormat.IndexType indexType = autoIndexBuffer.type();
                    GpuBuffer indexBuffer = autoIndexBuffer.getBuffer(data.drawState().indexCount());
                    GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Powerable Area vertex buffer", 40, data.vertexBuffer().remaining());
                    RenderSystem.getDevice().createCommandEncoder().writeToBuffer(vertexBuffer.slice(), data.vertexBuffer());
                    AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(renderState.invalid ? UNPOWERABLE_AREA : POWERABLE_AREA);
                    texture.setUseMipmaps(false);
                    try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Powerable Area", mainColor, OptionalInt.empty(), mainDepth, OptionalDouble.empty());){
                        pass.setPipeline(pipeline);
                        RenderSystem.bindDefaultUniforms((RenderPass)pass);
                        pass.setUniform("DynamicTransforms", slice);
                        pass.setIndexBuffer(indexBuffer, indexType);
                        pass.bindSampler("Sampler0", texture.getTextureView());
                        pass.setVertexBuffer(0, vertexBuffer);
                        pass.drawIndexed(0, 0, data.drawState().indexCount(), 1);
                    }
                }
            }
        }
    }

    private void tryAndTakeDebugScreenshot() {
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.hasShiftDown() && mc.hasAltDown() && mc.hasControlDown()) {
                if (!this.takenScreenshot) {
                    Screenshot.grab((File)mc.gameDirectory, null, (RenderTarget)this.electricityTarget, (int)1, component -> {});
                    this.takenScreenshot = true;
                }
            } else {
                this.takenScreenshot = false;
            }
        }
    }

    private void forEachVisibleElectricityNode(Camera camera, Consumer<IElectricityNode> consumer) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        ((CachedElectricityNodes)mc.level).refurbishedFurniture$ElectricityNodes().forEach(node -> {
            double maxDistance = ((Integer)Config.CLIENT.electricityViewDistance.get()).intValue();
            double distance = node.getNodePosition().distToCenterSqr((Position)camera.getPosition());
            if (distance <= maxDistance * maxDistance) {
                consumer.accept((IElectricityNode)node);
            }
        });
    }

    public static void drawColouredBox(PoseStack.Pose pose, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)ARGB.red((int)colour) / 255.0f;
        float green = (float)ARGB.green((int)colour) / 255.0f;
        float blue = (float)ARGB.blue((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
    }

    public static void drawInvertedColouredBox(PoseStack.Pose pose, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)ARGB.red((int)colour) / 255.0f;
        float green = (float)ARGB.green((int)colour) / 255.0f;
        float blue = (float)ARGB.blue((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
    }

    public static void drawTexturedBox(PoseStack.Pose pose, VertexConsumer consumer, AABB box, float minU, float minV, float maxU, float maxV) {
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxV, minU).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minV, minU).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minV, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxV, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void drawPowerableAreaBox(PoseStack.Pose pose, VertexConsumer consumer, AABB box) {
        float offset = (float)Util.getMillis() * 0.001f;
        float width = (float)(box.maxX - box.minX);
        float height = (float)(box.maxY - box.minY);
        if ((double)width > 0.01) {
            consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(0.0f, height + offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(width, height + offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(width, offset);
            consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(0.0f, offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(0.0f, height + offset);
            consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(width, height + offset);
            consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(width, offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(0.0f, offset);
        }
        if ((double)(width = (float)(box.maxZ - box.minZ)) > 0.01) {
            consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(0.0f, height + offset);
            consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(width, height + offset);
            consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(width, offset);
            consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(0.0f, offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(0.0f, height + offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(width, height + offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(width, offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(0.0f, offset);
        }
        width = (float)(box.maxX - box.minX);
        height = (float)(box.maxZ - box.minZ);
        if ((double)width > 0.01) {
            consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(height, width + offset);
            consumer.addVertex(pose, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(height, offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(0.0f, offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(0.0f, width + offset);
            consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(0.0f, height + offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(width, height + offset);
            consumer.addVertex(pose, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(width, offset);
            consumer.addVertex(pose, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(0.0f, offset);
        }
    }

    private static class SubmitStorage {
        private final List<NodeSubmit> nodeSubmits = new ArrayList<NodeSubmit>();
        private final List<ConnectionSubmit> connectionSubmits = new ArrayList<ConnectionSubmit>();
        private final List<LinkingConnectionSubmit> linkingConnectionSubmits = new ArrayList<LinkingConnectionSubmit>();

        private SubmitStorage() {
        }

        public void submitNode(PoseStack poseStack, NodeRenderState state) {
            this.nodeSubmits.add(new NodeSubmit(poseStack.last().copy(), (pose, consumer) -> {
                ElectricityRenderer.drawTexturedBox(pose, consumer, state.box, 0.0f, 0.0f, 0.25f, 0.25f);
                if (state.highlighted) {
                    ElectricityRenderer.drawInvertedColouredBox(pose, consumer, state.box.inflate(0.03125), state.highlightColour, 0.7f);
                }
            }));
        }

        public void submitConnection(PoseStack poseStack, ConnectionRenderState state) {
            this.connectionSubmits.add(new ConnectionSubmit(poseStack.last().copy(), state));
        }

        public void submitLinkingConnection(PoseStack poseStack, LinkingConnectionRenderState state) {
            this.linkingConnectionSubmits.add(new LinkingConnectionSubmit(poseStack.last().copy(), state));
        }

        private void clear() {
            this.nodeSubmits.clear();
            this.connectionSubmits.clear();
            this.linkingConnectionSubmits.clear();
        }

        private record NodeSubmit(PoseStack.Pose pose, BiConsumer<PoseStack.Pose, VertexConsumer> renderer) {
        }

        private record ConnectionSubmit(PoseStack.Pose pose, ConnectionRenderState connectionRenderState) {
        }

        private record LinkingConnectionSubmit(PoseStack.Pose pose, LinkingConnectionRenderState linkingConnectionRenderState) {
        }
    }
}

