/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.electricity;

import com.google.common.collect.Sets;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.electricity.WrenchContext;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PowerableArea {
    private final Set<BlockPos> sourcePositions = new HashSet<BlockPos>();
    private final Set<BlockPos> lastSourcePositions = new HashSet<BlockPos>();
    private VoxelShape cachedPowerableAreaShape;

    PowerableArea() {
    }

    public boolean exists() {
        return !this.sourcePositions.isEmpty();
    }

    public boolean containsLine(Level level, Vec3 start, Vec3 end) {
        for (BlockPos pos : this.sourcePositions) {
            AABB box = ISourceNode.createPowerableZone(level, pos);
            if (!box.contains(start) || !box.contains(end)) continue;
            return true;
        }
        return false;
    }

    public void updatePowerSources(Level level, WrenchContext context) {
        this.sourcePositions.clear();
        if (context.selectedNode() != null) {
            this.scanNetworkForPowerSources(context.selectedNode(), this.sourcePositions);
            if (context.targetingNode() != null && this.sourcePositions.isEmpty()) {
                this.scanNetworkForPowerSources(context.targetingNode(), this.sourcePositions);
            }
            return;
        }
        Connection connection = context.hoveredConnection();
        if (connection != null && !connection.isCrossingPowerableZone(level)) {
            this.scanNetworkForPowerSources(level, connection, this.sourcePositions);
        }
    }

    private void scanNetworkForPowerSources(Level level, Connection connection, Set<BlockPos> found) {
        Sets.SetView delta;
        IElectricityNode a = connection.getNodeA(level);
        IElectricityNode b = connection.getNodeB(level);
        if (a != null && b != null && !(delta = Sets.symmetricDifference(a.getPowerSources(), b.getPowerSources())).isEmpty()) {
            found.add((BlockPos)List.copyOf(delta).getFirst());
        }
    }

    private void scanNetworkForPowerSources(IElectricityNode start, Set<BlockPos> found) {
        if (!start.isSourceNode()) {
            int searchLimit = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
            IElectricityNode.searchNodes(start, searchLimit, true, node -> !node.isSourceNode(), IElectricityNode::isSourceNode).forEach(node -> found.add(node.getNodePosition()));
            return;
        }
        found.add(start.getNodePosition());
    }

    @Nullable
    public VoxelShape getPowerableAreaShape() {
        Minecraft mc = Minecraft.getInstance();
        if (this.sourcePositions.isEmpty() || mc.level == null) {
            return null;
        }
        if (this.lastSourcePositions.equals(this.sourcePositions)) {
            return this.cachedPowerableAreaShape;
        }
        this.sourcePositions.stream().map(pos -> ISourceNode.createPowerableZone((Level)mc.level, pos)).map(aabb -> {
            VoxelShape shape1 = Shapes.create((AABB)aabb);
            VoxelShape shape2 = Shapes.create((AABB)aabb.inflate(0.001));
            return Pair.of((Object)shape1, (Object)shape2);
        }).reduce((p1, p2) -> {
            VoxelShape shape1 = Shapes.joinUnoptimized((VoxelShape)((VoxelShape)p1.first()), (VoxelShape)((VoxelShape)p2.first()), (BooleanOp)BooleanOp.OR);
            VoxelShape shape2 = Shapes.joinUnoptimized((VoxelShape)((VoxelShape)p1.second()), (VoxelShape)((VoxelShape)p2.second()), (BooleanOp)BooleanOp.OR);
            return Pair.of((Object)shape1, (Object)shape2);
        }).map(pair -> Shapes.joinUnoptimized((VoxelShape)((VoxelShape)pair.first()), (VoxelShape)((VoxelShape)pair.second()), (BooleanOp)BooleanOp.ONLY_SECOND)).ifPresent(shape -> {
            this.cachedPowerableAreaShape = shape;
        });
        this.lastSourcePositions.clear();
        this.lastSourcePositions.addAll(this.sourcePositions);
        return this.cachedPowerableAreaShape;
    }

    public void invalidate() {
        this.sourcePositions.clear();
        this.lastSourcePositions.clear();
        this.cachedPowerableAreaShape = null;
    }
}

