/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.block.BasinBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.BathBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.FluidEntityRenderState;
import com.mrcrayfish.furniture.refurbished.client.util.SimpleFluidRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BathBlockEntityRenderer
implements BlockEntityRenderer<BathBlockEntity, FluidEntityRenderState> {
    public BathBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public FluidEntityRenderState createRenderState() {
        return new FluidEntityRenderState();
    }

    public void extractRenderState(BathBlockEntity entity, FluidEntityRenderState state, float partialTick, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)state, partialTick, camera, overlay);
        FluidEntityRenderState.extract(state, entity, entity.getLevel(), entity.getBlockPos());
        BlockState blockState = entity.getBlockState();
        if (blockState.hasProperty((Property)BasinBlock.DIRECTION)) {
            state.box = this.createBathFluidBox(entity, (Direction)blockState.getValue((Property)BasinBlock.DIRECTION));
        }
    }

    private AABB createBathFluidBox(BathBlockEntity bath, Direction direction) {
        if (bath.isHead()) {
            return SimpleFluidRenderer.createRotatedBox(direction, 0.0, 4.0, 2.0, 12.0, 15.0, 14.0);
        }
        return SimpleFluidRenderer.createRotatedBox(direction, 2.0, 4.0, 2.0, 16.0, 15.0, 14.0);
    }

    public void submit(FluidEntityRenderState renderState, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        SimpleFluidRenderer.submit(renderState, stack, collector);
    }
}

