/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.FryingPanRenderState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class FryingPanBlockEntityRenderer
implements BlockEntityRenderer<FryingPanBlockEntity, FryingPanRenderState> {
    private final ItemModelResolver itemModelResolver;

    public FryingPanBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public FryingPanRenderState createRenderState() {
        return new FryingPanRenderState();
    }

    public void extractRenderState(FryingPanBlockEntity entity, FryingPanRenderState renderState, float partialTick, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, camera, overlay);
        ItemStack stack = entity.getItem(0);
        if (!stack.isEmpty()) {
            ItemStackRenderState itemState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemState, stack, ItemDisplayContext.FIXED, entity.getLevel(), null, 0);
            renderState.item = itemState;
        }
        renderState.itemFlipped = entity.isFlipped();
        renderState.itemRotation = entity.getRotation();
        FlipAnimation animation = entity.getAnimation();
        renderState.animationPlaying = animation.isPlaying();
        renderState.animationTime = animation.isPlaying() ? animation.getTime(partialTick) : 0.0f;
    }

    public void submit(FryingPanRenderState renderState, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        float flipProgress = this.calculateFlipProgress(renderState.animationTime);
        float flipYOffset = 0.75f;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.140625, 0.5);
        poseStack.translate(0.0f, flipProgress * flipYOffset, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation(1.5707964f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotation(1.5707964f * (float)renderState.itemRotation));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation((float)Math.PI * -3 * renderState.animationTime));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation(!renderState.animationPlaying && renderState.itemFlipped ? (float)Math.PI : 0.0f));
        poseStack.scale(0.4375f, 0.4375f, 0.4375f);
        renderState.item.submit(poseStack, collector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }

    private float calculateFlipProgress(float time) {
        if ((double)time <= 0.5) {
            return 1.0f - (float)Math.pow(1.0f - (time /= 0.5f), 4.0);
        }
        time -= 0.5f;
        return 1.0f - (time /= 0.5f) * time * time * time;
    }
}

