/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.block.StorageJarBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.StorageJarBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.StorageJarRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class StorageJarRenderer
implements BlockEntityRenderer<StorageJarBlockEntity, StorageJarRenderState> {
    private final ItemModelResolver itemModelResolver;
    private final EntityRenderDispatcher entityRenderDispatcher;

    public StorageJarRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
        this.entityRenderDispatcher = context.entityRenderer();
    }

    public StorageJarRenderState createRenderState() {
        return new StorageJarRenderState();
    }

    public void extractRenderState(StorageJarBlockEntity entity, StorageJarRenderState renderState, float partialTick, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, camera, overlay);
        renderState.direction = (Direction)entity.getBlockState().getValueOrElse((Property)StorageJarBlock.DIRECTION, (Comparable)Direction.NORTH);
        renderState.items = new ItemStackRenderState[entity.getContainerSize()];
        for (int i = 0; i < entity.getContainerSize(); ++i) {
            ItemStack stack = entity.getItem(i);
            if (stack.isEmpty()) continue;
            if (renderState.label == null) {
                renderState.label = stack.getHoverName();
            }
            ItemStackRenderState itemState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemState, stack, ItemDisplayContext.NONE, entity.getLevel(), null, 0);
            renderState.items[i] = itemState;
        }
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)hitResult;
            renderState.showLabel = result.getBlockPos().equals((Object)entity.getBlockPos());
        }
        renderState.distanceToCamera = camera.distanceToSqr(entity.getBlockPos().getCenter());
    }

    public void submit(StorageJarRenderState renderState, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        if (renderState.items == null || renderState.items.length == 0) {
            return;
        }
        stack.pushPose();
        stack.translate(0.5, 0.015625, 0.5);
        stack.scale(0.499f, 0.499f, 0.499f);
        for (int i = 0; i < renderState.items.length; ++i) {
            ItemStackRenderState itemState = renderState.items[i];
            if (itemState == null) continue;
            stack.pushPose();
            stack.mulPose((Quaternionfc)renderState.direction.getRotation());
            stack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
            itemState.submit(stack, collector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            stack.popPose();
            stack.translate(0.0f, 0.0625f, 0.0f);
            stack.mulPose((Quaternionfc)Axis.YP.rotation(0.78149074f));
        }
        stack.popPose();
        if (renderState.showLabel && renderState.label != null) {
            collector.submitNameTag(stack, new Vec3(0.5, 0.5, 0.5), 0, renderState.label, true, renderState.lightCoords, renderState.distanceToCamera, cameraState);
        }
    }
}

