/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.block.TelevisionBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.TelevisionBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.CustomSheets;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.TelevisionRenderState;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class TelevisionBlockEntityRenderer
implements BlockEntityRenderer<TelevisionBlockEntity, TelevisionRenderState> {
    private final MaterialSet materials;

    public TelevisionBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.materials = context.materials();
    }

    public TelevisionRenderState createRenderState() {
        return new TelevisionRenderState();
    }

    public void extractRenderState(TelevisionBlockEntity entity, TelevisionRenderState renderState, float partialTick, Vec3 camera, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, camera, overlay);
        renderState.powered = entity.isNodePowered();
        renderState.currentChannel = entity.getCurrentChannel().id();
        renderState.direction = (Direction)entity.getBlockState().getValueOrElse((Property)TelevisionBlock.DIRECTION, (Comparable)Direction.NORTH);
    }

    public void submit(TelevisionRenderState renderState, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        if (renderState.powered) {
            stack.pushPose();
            stack.translate(0.5, 0.0, 0.5);
            stack.mulPose((Quaternionfc)Axis.YN.rotation(1.5707964f * (float)renderState.direction.get2DDataValue()));
            stack.translate(-0.5, 0.0, -0.345);
            Material material = CustomSheets.getTelevisionChannelMaterial(renderState.currentChannel);
            RenderType renderType = material.renderType(ClientServices.PLATFORM::getTelevisionScreenRenderType);
            TextureAtlasSprite sprite = this.materials.get(material);
            collector.submitCustomGeometry(stack, renderType, (pose, consumer) -> {
                float offset = 0.003125f;
                Vec3i normal = renderState.direction.getUnitVec3i();
                consumer.addVertex(pose, 0.75f + offset, 0.625f + offset, 0.0f).setColor(255, 255, 255, 255).setUv(sprite.getU(0.0f), sprite.getV(0.0f)).setLight(0xF000F0).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
                consumer.addVertex(pose, 0.75f + offset, 0.1875f - offset, 0.0f).setColor(255, 255, 255, 255).setUv(sprite.getU(0.0f), sprite.getV(1.0f)).setLight(0xF000F0).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
                consumer.addVertex(pose, 0.25f - offset, 0.1875f - offset, 0.0f).setColor(255, 255, 255, 255).setUv(sprite.getU(1.0f), sprite.getV(1.0f)).setLight(0xF000F0).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
                consumer.addVertex(pose, 0.25f - offset, 0.625f + offset, 0.0f).setColor(255, 255, 255, 255).setUv(sprite.getU(1.0f), sprite.getV(0.0f)).setLight(0xF000F0).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
            });
            stack.popPose();
        }
    }
}

