/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.google.common.collect.Sets;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import java.lang.ref.WeakReference;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Connection {
    private static final int DEFAULT_COLOUR = -1;
    private static final int POWERED_COLOUR = -9652;
    private static final int CROSSING_ZONE_COLOUR = -3983818;
    private final Node a;
    private final Node b;

    private Connection(BlockPos a, BlockPos b) {
        int c = a.compareTo((Vec3i)b);
        this.a = new Node(c > 0 ? a : b);
        this.b = new Node(c > 0 ? b : a);
    }

    public BlockPos getPosA() {
        return this.a.pos;
    }

    public BlockPos getPosB() {
        return this.b.pos;
    }

    @Nullable
    public IElectricityNode getNodeA(Level level) {
        return this.a.getElectricNode(level);
    }

    @Nullable
    public IElectricityNode getNodeB(Level level) {
        return this.b.getElectricNode(level);
    }

    public boolean isConnected(Level level) {
        return this.a.isValid(level) && this.b.isValid(level);
    }

    public boolean isPowered(Level level) {
        IElectricityNode a = this.a.getElectricNode(level);
        IElectricityNode b = this.b.getElectricNode(level);
        if (a == null || b == null) {
            return false;
        }
        if (!a.canPowerTraverseNode() && !b.canPowerTraverseNode()) {
            return a.isNodePowered() && a.isSourceNode() || b.isNodePowered() && b.isSourceNode();
        }
        return a.isNodePowered() && b.isNodePowered();
    }

    public boolean isCrossingPowerableZone(Level level) {
        Set<BlockPos> bPowerSources;
        Set<BlockPos> aPowerSources;
        IElectricityNode a = this.a.getElectricNode(level);
        IElectricityNode b = this.b.getElectricNode(level);
        if (a != null && b != null && !(aPowerSources = a.getPowerSources()).equals(bPowerSources = b.getPowerSources())) {
            Vec3 aPos = this.a.pos.getCenter();
            Vec3 bPos = this.b.pos.getCenter();
            for (BlockPos source : Sets.symmetricDifference(aPowerSources, bPowerSources)) {
                AABB box = ISourceNode.createPowerableZone(level, source);
                if (box.contains(aPos) && box.contains(bPos)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public IElectricityNode getOtherNode(IElectricityNode node) {
        if (this.a.pos.equals((Object)node.getNodePosition())) {
            return this.b.getElectricNode(node.getNodeLevel());
        }
        if (this.b.pos.equals((Object)node.getNodePosition())) {
            return this.a.getElectricNode(node.getNodeLevel());
        }
        return null;
    }

    @Nullable
    public BlockPos getOtherPos(BlockPos pos) {
        if (this.a.pos.equals((Object)pos)) {
            return this.b.pos;
        }
        if (this.b.pos.equals((Object)pos)) {
            return this.a.pos;
        }
        return null;
    }

    public int getColour(Level level) {
        if (this.isCrossingPowerableZone(level)) {
            return -3983818;
        }
        if (this.isPowered(level)) {
            return -9652;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        return this.a.equals(other.a) && this.b.equals(other.b);
    }

    public int hashCode() {
        int result = this.a.hashCode();
        result = 31 * result + this.b.hashCode();
        return result;
    }

    public static Connection of(BlockPos a, BlockPos b) {
        return new Connection(a, b);
    }

    private static class Node {
        private final BlockPos pos;
        private WeakReference<IElectricityNode> ref;
        private Status status = Status.ACTIVE;

        private Node(BlockPos pos) {
            this.pos = pos;
            this.ref = new WeakReference<Object>(null);
        }

        private boolean isValid(Level level) {
            this.updateStatus(level);
            return this.status.valid;
        }

        @Nullable
        private IElectricityNode getElectricNode(Level level) {
            this.updateStatus(level);
            return (IElectricityNode)this.ref.get();
        }

        private void updateStatus(Level level) {
            IElectricityNode node = (IElectricityNode)this.ref.get();
            if (node != null && node.isNodeValid()) {
                this.status = Status.ACTIVE;
                return;
            }
            if (level.isLoaded(this.pos)) {
                IElectricityNode found;
                Object v;
                LevelChunk chunk = level.getChunkAt(this.pos);
                if (chunk != null && (v = chunk.getBlockEntities().get(this.pos)) instanceof IElectricityNode && (found = (IElectricityNode)v).isNodeValid()) {
                    this.ref = new WeakReference<IElectricityNode>(found);
                    this.status = Status.ACTIVE;
                } else {
                    this.ref.clear();
                    this.status = Status.INVALID;
                }
            } else {
                this.ref.clear();
                this.status = Status.UNDETERMINED;
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.pos.equals((Object)other.pos);
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public static enum Status {
            ACTIVE(true),
            UNDETERMINED(true),
            INVALID(false);

            final boolean valid;

            private Status(boolean valid) {
                this.valid = valid;
            }
        }
    }
}

