/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.play;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.TelevisionBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.client.ClientComputer;
import com.mrcrayfish.furniture.refurbished.client.FurnitureScreens;
import com.mrcrayfish.furniture.refurbished.client.ToolAnimationRenderer;
import com.mrcrayfish.furniture.refurbished.client.electricity.WrenchHandler;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.PostBoxScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.toast.ItemToast;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.graphics.PaddleBallGraphics;
import com.mrcrayfish.furniture.refurbished.inventory.ComputerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.network.message.MessageClearMessage;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerState;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDoorbellNotification;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlushItem;
import com.mrcrayfish.furniture.refurbished.network.message.MessageNameMailbox;
import com.mrcrayfish.furniture.refurbished.network.message.MessagePaddleBall;
import com.mrcrayfish.furniture.refurbished.network.message.MessageShowDeliveryResult;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncFluid;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncLink;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTelevisionChannel;
import com.mrcrayfish.furniture.refurbished.network.message.MessageToolAnimation;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClientPlayHandler {
    public static void handleMessageSyncFluid(MessageSyncFluid message) {
        IFluidContainerBlock block;
        FluidContainer container;
        Minecraft mc = Minecraft.getInstance();
        Level level = (Level)Objects.requireNonNull(mc.level);
        BlockEntity blockEntity = level.getBlockEntity(message.pos());
        if (blockEntity instanceof IFluidContainerBlock && (container = (block = (IFluidContainerBlock)blockEntity).getFluidContainer()) != null) {
            container.handleSync(level, message.fluid(), message.amount());
        }
    }

    public static void handleMessageFlipAnimation(MessageFlipAnimation message) {
        Minecraft mc = Minecraft.getInstance();
        Level level = (Level)Objects.requireNonNull(mc.level);
        BlockEntity blockEntity = level.getBlockEntity(message.pos());
        if (blockEntity instanceof GrillBlockEntity) {
            GrillBlockEntity grill = (GrillBlockEntity)blockEntity;
            grill.playFlipAnimation(message.index());
        } else {
            blockEntity = level.getBlockEntity(message.pos());
            if (blockEntity instanceof FryingPanBlockEntity) {
                FryingPanBlockEntity fryingPan = (FryingPanBlockEntity)blockEntity;
                fryingPan.playFlipAnimation(message.index());
            }
        }
    }

    public static void handleMessageClearMessage(MessageClearMessage message) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof PostBoxScreen) {
            PostBoxScreen postBox = (PostBoxScreen)screen;
            postBox.clearMessage();
        }
    }

    public static void handleMessageDoorbell(MessageDoorbellNotification message) {
        if (((Boolean)Config.CLIENT.doorbellNotification.get()).booleanValue()) {
            Minecraft mc = Minecraft.getInstance();
            MutableComponent title = Utils.translation("gui", "doorbell_rang", new Object[0]);
            MutableComponent description = Component.literal((String)message.name());
            mc.getToastManager().addToast((Toast)new ItemToast((Component)title, (Component)description, new ItemStack((ItemLike)Items.BELL)));
        }
    }

    public static void handleMessageSyncLink(MessageSyncLink message) {
        WrenchHandler.get().setSelectedNodePos(message.pos());
    }

    public static void handleMessageTelevisionChannel(MessageTelevisionChannel message) {
        Minecraft mc = Minecraft.getInstance();
        Level level = (Level)Objects.requireNonNull(mc.level);
        BlockEntity blockEntity = level.getBlockEntity(message.pos());
        if (blockEntity instanceof TelevisionBlockEntity) {
            TelevisionBlockEntity television = (TelevisionBlockEntity)blockEntity;
            television.setChannelFromId(message.channel());
        }
    }

    public static void handleMessageComputerState(MessageComputerState message) {
        Minecraft mc = Minecraft.getInstance();
        AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
        if (abstractContainerMenu instanceof ComputerMenu) {
            ComputerMenu menu = (ComputerMenu)abstractContainerMenu;
            ClientComputer computer = (ClientComputer)menu.getComputer();
            computer.launchProgram(message.id());
        }
    }

    @Nullable
    private static PaddleBallGraphics getPaddleGame() {
        ComputerMenu menu;
        ClientComputer computer;
        DisplayableProgram<?> displayableProgram;
        Minecraft mc = Minecraft.getInstance();
        AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
        if (abstractContainerMenu instanceof ComputerMenu && (displayableProgram = (computer = (ClientComputer)(menu = (ComputerMenu)abstractContainerMenu).getComputer()).getDisplayable()) instanceof PaddleBallGraphics) {
            PaddleBallGraphics game = (PaddleBallGraphics)displayableProgram;
            return game;
        }
        return null;
    }

    public static void handleMessageTennisGamePaddlePosition(MessagePaddleBall.PaddlePosition message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.updatePaddles(message.playerPos(), message.opponentPos());
        }
    }

    public static void handleMessageTennisGameBallUpdate(MessagePaddleBall.BallUpdate message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.updateBall(message.ballX(), message.ballY(), message.velocityX(), message.velocityY());
        }
    }

    public static void handleMessagePaddleBallEvent(MessagePaddleBall.Event message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.handleEvent(message.data());
        }
    }

    public static void handleMessagePaddleBallOpponentName(MessagePaddleBall.OpponentName message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.handleOpponentName(message.name());
        }
    }

    public static void handleMessageToolAnimation(MessageToolAnimation message) {
        switch (message.tool()) {
            case SPATULA: {
                ToolAnimationRenderer.get().playSpatulaAnimation(message.pos(), message.direction());
                break;
            }
            case KNIFE: {
                ToolAnimationRenderer.get().playKnifeAnimation(message.pos(), message.direction());
            }
        }
    }

    public static void handleMessageFlushItem(MessageFlushItem message) {
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && (entity = mc.level.getEntity(message.entityId())) instanceof ItemEntity) {
            ItemEntity entity2 = (ItemEntity)entity;
            EntityRenderDispatcher dispatcher = mc.getEntityRenderDispatcher();
            RenderBuffers buffers = mc.renderBuffers();
            Vec3 pos = Vec3.atCenterOf((Vec3i)message.pos());
            mc.level.removeEntity(message.entityId(), Entity.RemovalReason.DISCARDED);
        }
    }

    public static void handleMessageWaterTapAnimation(MessageWaterTapAnimation message) {
        BlockEntity blockEntity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && (blockEntity = mc.level.getBlockEntity(message.pos())) instanceof IWaterTap) {
            IWaterTap tap = (IWaterTap)blockEntity;
            tap.playWaterAnimation();
        }
    }

    public static void handleMessageWorkbenchItemCounts(MessageWorkbench.ItemCounts message) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (abstractContainerMenu = mc.player.containerMenu) instanceof WorkbenchMenu) {
            WorkbenchMenu menu = (WorkbenchMenu)abstractContainerMenu;
            menu.updateItemCounts(message.counts());
        }
    }

    public static void handleMessageNameMailbox(MessageNameMailbox message) {
        FurnitureScreens.openNameableScreen(message.pos(), (Component)Utils.translation("gui", "set_mailbox_name", new Object[0]), 32);
    }

    public static void handleMessageShowDeliveryResult(MessageShowDeliveryResult message) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof PostBoxScreen) {
            PostBoxScreen postBox = (PostBoxScreen)screen;
            postBox.showResponse(message.result());
        }
    }
}

