/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.platform;

import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.platform.services.IFluidHelper;
import it.unimi.dsi.fastutil.Pair;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidStacksResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class NeoForgeFluidHelper
implements IFluidHelper {
    @Override
    public long getBucketCapacity() {
        return 1000L;
    }

    @Override
    public long getBottleCapacity() {
        return 1000L;
    }

    @Override
    public SoundEvent getBucketEmptySound(Fluid fluid) {
        return fluid.getFluidType().getSound(SoundActions.BUCKET_EMPTY);
    }

    @Override
    public FluidContainer createFluidContainer(long capacity, @Nullable Consumer<FluidContainer> onChange) {
        return new NeoForgeFluidContainer(capacity, onChange);
    }

    @Override
    public InteractionResult performInteractionWithBlock(Player player, InteractionHand hand, Level level, BlockPos pos, Direction face) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, (Direction)face) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public Fluid getMilkFluid() {
        return (Fluid)NeoForgeMod.MILK.get();
    }

    public static class NeoForgeFluidContainer
    extends FluidContainer {
        protected final FluidStacksResourceHandler tank;
        private final int capacity;

        protected NeoForgeFluidContainer(long capacity, final @Nullable Consumer<FluidContainer> onChange) {
            this.tank = new FluidStacksResourceHandler(1, (int)capacity){

                protected void onContentsChanged(int index, FluidStack previousContents) {
                    if (onChange != null) {
                        onChange.accept(this);
                    }
                }
            };
            this.capacity = (int)capacity;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }

        @Override
        public boolean isEmpty() {
            return ((FluidResource)this.tank.getResource(0)).isEmpty();
        }

        @Override
        public Fluid getStoredFluid() {
            return ((FluidResource)this.tank.getResource(0)).getFluid();
        }

        @Override
        public long getStoredAmount() {
            return this.tank.getAmountAsLong(0);
        }

        @Override
        protected void setStored(Fluid fluid, long amount) {
            this.tank.set(0, (Resource)FluidResource.of((Fluid)fluid), (int)amount);
        }

        @Override
        public long push(Fluid fluid, long amount, boolean simulate) {
            try (Transaction tx = Transaction.open(null);){
                int inserted = this.tank.insert((Resource)FluidResource.of((Fluid)fluid), (int)amount, (TransactionContext)tx);
                if (!simulate) {
                    tx.commit();
                }
                long l = inserted;
                return l;
            }
        }

        @Override
        public Pair<Fluid, Long> pull(long amount, boolean simulate) {
            try (Transaction tx = Transaction.open(null);){
                FluidResource resource = (FluidResource)this.tank.getResource(0);
                if (resource.isEmpty()) {
                    Pair pair = Pair.of((Object)Fluids.EMPTY, (Object)0L);
                    return pair;
                }
                int extracted = this.tank.extract((Resource)resource, (int)amount, (TransactionContext)tx);
                if (!simulate) {
                    tx.commit();
                }
                Pair pair = Pair.of((Object)resource.getFluid(), (Object)extracted);
                return pair;
            }
        }

        @Override
        public void load(ValueInput input) {
            this.tank.deserialize(input);
        }

        @Override
        public void save(ValueOutput output) {
            this.tank.serialize(output);
        }

        public FluidStacksResourceHandler getTank() {
            return this.tank;
        }
    }
}

